#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
#--------------------------------------------------------------
# Mark5cEmu -- A Haystack Mark5C command emulator and remapper
#
# Author:  Jan Wagner, Metsahovi Radio Observatory/TKK
# License: GPU GPL
#
#--------------------------------------------------------------
# <mark5cEmuInnerstate.py> : a class that holds the internal
# state of the emulator, like what commands have been started,
# what fake bank has been selected, etc
#--------------------------------------------------------------

class Personality:
    mark5C, mark5Cminus, file = range(3)

class Innerstate:
	# some constants from the Mark5C Software Interface Specifications
	# with self-invented names
	EI_READY = 0x01
	EI_ERRORS_PENDING = 0x02
	EI_BUSY = 0x04
	EI_DELAYED_CMD_PENDING = 0x08

	EI_DELAYED_QUERY_PENDING = 0x0010
	EI_FIFO_MODE  = 0x0020
	EI_RECORDING  = 0x0040
	EI_DISKS_FULL = 0x0080
	EI_SLOW_DISKS = 0x0400

	EI_DISK2FILE_RUNNING = 0x1000
	EI_FILE2DISK_RUNNING = 0x2000

	EI_DIM_ARMED = 0x040000

	EI_BANK_A_SELECTED = 0x100000
	EI_BANK_A_READY    = 0x200000
	EI_BANK_A_BUGGERIT = 0x400000
	EI_BANK_A_RDONLY   = 0x800000

	EI_BANK_B_SELECTED = 0x01000000
	EI_BANK_B_READY    = 0x02000000
	EI_BANK_B_BUGGERIT = 0x04000000
	EI_BANK_B_RDONLY   = 0x08000000

	# internal status and settings
	__statusword = 0x01
	__personality = Personality.file

	# recording settings
	fill_pattern = 0x11223344
	MAC_list = ['00:00:00:00:00:00']
	port_list = ['46220']

	# active RAID selection
	numdisks = 0
	bank = 0
	vsn = "XXX-0000/0000/0000"
	active_raid_path = '/mnt/diskpacks/pack0data/'
	active_descriptor_path = '/mnt/diskpacks/pack0meta/'

	vdifrecorder_pid = 0			# process ID of spawned vdif capture program
	vdifrecorder_file = '__'
	previous_vdifrecorder_file = '__'
	protect = 1						# 0 write-protected OFF - 1 write-protect ON
	
	def getStatusword():
		return __statusword
