#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
#--------------------------------------------------------------
# Mark5cEmu -- A Haystack Mark5C command emulator and remapper
#
# Author:  Jan Wagner and Guifre Molera
# Metsahovi Radio Observatory/TKK
# License: GPU GPL
#
#--------------------------------------------------------------

"""@package mark5cEmuInfocommands
 <mark5cEmuInfocommands.py> : a number of simple Mark5 cmds
 that perform a read-only query and return its result, say,
 get the amount of free disk space and number of disks
"""

import socket
import sys
import threading
import os
import subprocess
import struct
import sys, stat, os
import grp, pwd
import locale
import time
import commands

MAX_NUM_DISKS = 4

from mark5cEmuHelpers import *

# endl = ' ;\r\n'
endl = ' ;\n'
	
def ss_revQ(csocket, istate, arglist):
	csocket.send ('0 : StreamDrop Lite v1.00 Firmware 0.02rc57')
	csocket.send (endl)
	# 'BoardType PCI-816VXF2 : SerialNum 8239 : ApiVersion 7.10 : ApiDateCode Apr 22 2008 : FirmwareVersion 12.05 : FirmDateCode Apr 21 2008 : MonitorVersion 6.02 : XbarVersion 3.20 : AtaVersion 1.05 : UAtaVersion 0.00 : DriverVersion 910 ;'

def modeQ(csocket, istate, arglist):
	csocket.send('0 : VDIF')
	csocket.send(endl)

def modeX(csocket, istate, arglist):
	csocket.send('0 : There Can Be Only One : VDIF')
	csocket.send(endl)

def play_rateQ(csocket, istate, arglist):
	csocket.send('0 : 1024.0000 : 1024.0000 : 1024.0000')
	csocket.send(endl)

def play_rateX(csocket, istate, arglist):
	csocket.send('0 : Its not how you stand by your car its how you race your car')
	csocket.send(endl)

def scan_setQ(csocket, istate, arglist):
	csocket.send('6 : Not yet implemented')
	csocket.send(endl)

def scan_setX(csocket, istate, arglist):
	csocket.send('6 : Not yet implemented')
	csocket.send(endl)

def pointersQ(csocket, istate, arglist):
	csocket.send('0 : 0 : 0 : 0' + endl)

def positionQ(csocket, istate, arglist):
	csocket.send('0 : 0 : 0' + endl)

def bank_infoQ(csocket, istate, arglist):
	"""Information of bank inserted, if only one diskpack in use is not needed.
	"""
	#DEBUG MODE
	istate.bank = 1
 	istate.vsn = "FGI-0001/2560/1024"
 	istate.banksOn = [1,2,4]
	#DEBUG MODE
	
	list = istate.banksOn
	sout = ""
	for i in (1,MAX_NUM_DISKS):
		try:
			if (list.count(i)==1):
				cmd="df -P | grep /dev/mdp%dp1 | awk '{print $4}'" % i
				totalspace = subprocess.call(cmd,shell=True)
				cmd="df -P | grep /dev/mdp%dp1 | awk '{print $2}'" % i
				freespace = subprocess.call(cmd,shell=True)
				sout += " %d : %s / %s :" % (i,totalspace,freespace)
			else:
				sout += " %d : -" % i
		except:
			print "subprocess.call error"
	csocket.send (sout)
	csocket.send (endl)

def bank_setX(csocket, istate, arglist):
	"""It allows change between different diskpacks.
	TODO: this should update istate.active_descriptor_path and istate.active_raid_path
	"""
	try:
		if (arglist[0] == 'inc'):
			new_bank = istate.bank + 0 # + 1
		elif (arglist[0] == 'dec'):
			new_bank = istate.bank - 0 # - 1
		else:
			new_bank = int(arglist[0])
	except:
		print 'bank_set: invalid or non-numeric bank argument ' + arglist[0]
		new_bank = -1

	sout = ''
	if ((new_bank < 0) or (new_bank > 4)):
		sout = '-1 : Incorrect command'
	else:
		if (new_bank == istate.bank):
			sout = '0 : %c : %s : No change in bank' % (ord('A')+istate.bank,istate.vsn)
		else:
			new_active_raid_path = '/mnt/diskpacks/pack' + str(new_bank) + 'data/'
			new_active_descriptor_path = '/mnt/diskpacks/pack' + str(new_bank) + 'meta/'
			try:
				f = open(istate.active_descriptor_path + '/VSN.txt')
				new_vsn = f.read()
				f.close()
				istate.active_raid_path = new_active_raid_path
				istate.active_descriptor_path = active_descriptor_path
				istate.bank = new_bank
				istate.vsn = new_vsn
				sout = '0 : %c : %s : Bank selected' % (ord('A')+istate.bank,istate.vsn)
			except:
				print 'No bank info at ' + new_active_descriptor_path + '/VSN.txt'
				sout = '-1 : Bank not available'
	csocket.send(sout);
	csocket.send(endl);		

def bank_setQ(csocket, istate, arglist):
	"""Asks which bank is set.
	"""
	sout = '0 : %c : %s : %s' % (ord('A')+istate.bank, istate.vsn, istate.active_raid_path)
	csocket.send (sout)
	csocket.send (endl)


def dir_infoQ(csocket, istate, arglist):
	"""Returns a list of scans on the RAID, basically 'ls' with timestamps.
	"""
	if len(sys.argv) == 1:
		files=os.listdir(istate.active_raid_path)
		files=[filename for filename in files if filename[0] != '.']
	else:
		files=sys.argv[1:]

	locale.setlocale(locale.LC_ALL,'')
	files.sort(locale.strcoll)

	sout = ''
	for filename in files:
		fullpath = istate.active_raid_path + '/' + filename
		try:
			stat_info=os.lstat(fullpath)
		except:
			sys.stderr.write("%s: No such file or directory\n" % fullpath)
			continue
		size_str = "%d" % stat_info.st_size
		time_fmt = '%Yy%jd%Hh%Mm%Ss' # for example: 2009y217d17h09m09s
		time_str = time.strftime(time_fmt, time.gmtime(stat_info.st_mtime))
		sout += (": %s %s %s " % (filename, size_str, time_str))
	csocket.send ('0 ' + sout)
	csocket.send (endl)
		

def disk_modelQ(csocket,istate,arglist):
	"""Returns the disk model infos of the RAID disks
	"""
	modellist = '0 : bank %d ' % istate.bank
	disknr = 0
	try:
		f = open(istate.active_descriptor_path + '/DiskModels.txt', 'r')
		while 1:
			result = f.readline()
			if (not result):
				break
			result = result.strip()
			if (result==''):
				continue
			modellist += ": %d : %s " % (disknr,result)
			disknr = disknr + 1
		f.close()
	except:
		print 'Error while reading ' + istate.active_descriptor_path + '/DiskModels.txt'
		modellist += '1 : DiskModels.txt read error'
	csocket.send (modellist)
	csocket.send (endl)
 	
def disk_serialQ(csocket,istate,arglist):
	"""Returns the manufacturer serial numbers of the RAID disks
	"""
	seriallist = '0 : bank %d ' % istate.bank
	disknr = 0
	try:
		f = open(istate.active_descriptor_path + '/DiskSerials.txt', 'r')
		while 1:
			result = f.readline()
			if (not result):
				break
			result = result.strip()
			if (result==''):
				continue
			seriallist += ": %d : %s " % (disknr,result)
			disknr = disknr + 1
		f.close()
	except:
		print 'Error while reading ' + istate.active_descriptor_path + '/DiskSerials.txt'
		seriallist += '1 : DiskSerials.txt read error'
	csocket.send ('0 : ' + seriallist)
	csocket.send (endl)
 
def disk_sizeQ(csocket,istate,arglist):
	"""Returns disk size properties of every disk in the RAID
	"""
	sout = "0 : bank: %s" % istate.bank
	fname = istate.active_descriptor_path + '/Diskpacksize.txt'
	f = open(fname,'r')
	while 1:
		string = f.readline()
		if (not string):
			break
		else:
			sout += '%d : %s : ' % (i,string)
	f.close()
	csocket.send (sout)
	csocket.send (endl)

def protectQ(csocket, istate, arglist):
	"""Returns RAID write protection status
	"""
	if (istate.protect == 0):
		csocket.send('0 : off')
	else:
		csocket.send('0 : on')
	csocket.send(endl)

def protectX(csocket, istate, arglist):
	"""Change the RAID write protection on or off
	"""
	if ((arglist[0] == 'off') or (arglist[0] == '0')):
		istate.protect = 0
		csocket.send('0 : off')
	else:
		istate.protect = 1
		csocket.send('0 : on')
	csocket.send(endl)
	
def resetX(csocket, istate, arglist):
	"""Should reset all the running commands of Mark5
	"""
	sout = '0 : done'
	if(istate.protect==0):
		if(arglist[1]=="erase"):
			subprocess.call("rm -f /raid%dp1/*",shell=True) % istate.bank
		if(arglist[1]=="erase_last_scan"):
			istate.lastscan=""
			subprocess.call("rm -f /raid%dp1/%s",shell=True) % (istate.bank,istate.lastscan)
		if(arglist[1]=="abort"):
			print "TODO: KIll any disk2net, disk2file or file2disk"
		else:
			print "error sending command"
	else:
		sout = '-1 : run protect=off first'
	istate.protect=1 	# protect=off command keeps alive only for one instruction, so need to return to protected.	
	csocket.send (sout)
	csocket.send (endl)
		
def vsnX(csocket, istate, arglist):
	"""Change the VSN label
	"""
	if(istate.protect!=0):
		csocket.send('-1 : run protect=off first')
	else:
		fname = istate.active_descriptor_path + '/VSN.txt'
		try:
			f = open(fname, 'w')
			f.write(arglist[0])
			f.close()
		except:
			print "vsnX: could not write to " + fname
		csocket.send('0 : VSN changed to ' + arglist[0])
		istate.protect = 1
	csocket.send(endl)
	
def vsnQ(csocket, istate, arglist):
	"""Return the VSN label
	"""
	result = ''
	try:
		f = open(istate.active_descriptor_path + '/VSN.txt')
		result = f.read()
		f.close()
	except:
		result = 'VSNtxtNotFound'
	csocket.send ('0 : bank 0 : ' + result)
	csocket.send (endl)

def mac_listX(csocket, istate, arglist):
	"""Change MAC list - data can be filtered so that only Ethernet frames from those MACs are recorded
	"""
	macs = map(lambda cvt: cvt.replace('.',':'), arglist)
	istate.MAC_list = macs
	csocket.send('0' + endl)

def mac_listQ(csocket, istate, arglist):
	"""Returns current MAC devices list potentially used in recording
	"""
	csocket.send('0 : ')
	for mac in istate.MAC_list:
		cmac = mac.replace(':','.')
		csocket.send(cmac)
		csocket.send(' : ')
	csocket.send(endl)

def port_listX(csocket, istate, arglist):
	istate.port_list = arglist
	csocket.send('0' + endl)

def port_listQ(csocket, istate, arglist):
	"""Asks communication ports in use
	"""
	csocket.send('0 : ')
	for port in istate.port_list:
		csocket.send(port)
		csocket.send(' : ')
	csocket.send(endl)

def statusQ(csocket, istate, arglist):
	csocket.send('0 : 0x00300001 : 0 : I feel the universe functioning perfectly')
	csocket.send(endl)

def dts_idQ(csocket, istate, arglist):
	csocket.send('0 : EXPReS : 2009y001d12h : 1 : nasbox : 1 : 1 : xx : 0x00 : 0x00')
	csocket.send(endl)

def os_revQ(csocket, istate, arglist):
	"""Returns operation system version
	"""
	kname = commands.getstatusoutput("uname -a")
	csocket.send('0 : ' + kname[1])
	csocket.send(endl)

def get_statsQ(csocket, istate, arglist):
	"""Could return slow-disk information and other such useless stuff
	"""
	csocket.send('0 : 0 : 36570 : 1 : 0 : 0 : 0 : 0 : 0 : 0 : 0 : OK')
	csocket.send(endl)

def recordX(csocket, istate, arglist):
	"""Start or stop recording
	Recording is done via a spawned C/C++ program, the default is 'ibobvdifclient'
	"""
	# 'record = on : 326-0812 : u7326f : 3c84' in the Mk5A Logs
	# {'on', 'expt_stationID_scanname'} in disk_record=... from FS1
	if ((arglist[0] == 'off') or (arglist[0] == '0')):
		if (istate.vdifrecorder_pid > 0):
			print 'spawning a killall -SIGINT ibobvdifclient'
			os.spawnlp(os.P_WAIT, 'killall', 'killall', '-SIGINT', 'ibobvdifclient')
			csocket.send('0 : Stopped')
		else:
			csocket.send('0 : Not active')
		istate.vdifrecorder_pid = 0
		istate.previous_vdifrecorder_file = istate.vdifrecorder_file
		istate.vdifrecorder_file = ''
	elif (((arglist[0] == 'on') or (arglist[0] == '1')) and (len(arglist) >= 2)):
		if (istate.vdifrecorder_pid != 0):
			csocket.send('-1 : Already recording ' + istate.vdifrecorder_file)
		else:
			# run: ibobvdifclient <port> <length> <outfilename> : length of -1 means infinite until SIGINT
			istate.vdifrecorder_file  = istate.active_raid_path + '/'
			istate.vdifrecorder_file += arglist[1] +  '.vdif'
			istate.vdifrecorder_pid = subprocess.Popen(['ibobvdifclient', '46220', '-1', istate.vdifrecorder_file], stdout=None)
			print 'invoked ibobvdifclient for output file ' + istate.vdifrecorder_file + ' and got PID ' + str(istate.vdifrecorder_pid.pid)
			csocket.send('0 : Recording started')
	else:
		csocket.send('-1 : Illegal or missing arguments')
	csocket.send(endl)

def recordQ(csocket, istate, arglist):
	if (istate.vdifrecorder_pid != 0):
		csocket.send('0 : on : 1 : ' + istate.vdifrecorder_file);
	else:
		csocket.send('0 : off : 1 :')
	csocket.send(endl)

def scan_checkQ(csocket, istate, arglist):
	"""Return the state and length of the current scan
	The official format is something like 0 : 229 : euro96_mh_333-1143 : mark4 : 32 : 2008y333d11h43m12.1600s : 174.8s : 4.000 : 0 ;
	"""
	if (istate.vdifrecorder_file == '__' or istate.vdifrecorder_file == ''):
		if (istate.previous_vdifrecorder_file == '__' or istate.previous_vdifrecorder_file == ''):
			csocket.send('6 : No scans')
		else:
			csocket.send('0 : 1 : ' + istate.previous_vdifrecorder_file + ' : EXPReS : 1 : timeIsRelative : 100.0s : 1024.000 : 0')
	else:
		csocket.send('0 : 1 : ' + istate.vdifrecorder_file + ' : EXPReS : 1 : timeIsRelative : 100.0s : 1024.000 : 0')
	csocket.send(endl)

def rtimeQ(csocket, istate, arglist):
	"""Free disk space converted into remaining seconds at the current data rate.
	!rtime? 0 : 83704.9 : 1339.278002624 : 67.0 : mark4 : 32 : 4.000 : 128.0 ;"
				seconds : gbytes : percent left : type : tracks : bandwidth : total rate
	"""
	st = os.statvfs(istate.active_raid_path)
	bytes_free = st.f_bsize * st.f_bfree
	bytes_capacity = st.f_bsize * st.f_blocks
	gbytes_free = bytes_free / 1e9
	seconds = 60*60*24 * 4
	percent = 100.0 * bytes_free / bytes_capacity
	# seconds = int(round(8.0 * bytes_free / 4e9))
	sout = '0 : %d : %.2f : %.1f : vdif : 1 : 1024 : 1024 : Chuck Norris has counted to infinity. Twice.' % (seconds,gbytes_free,percent)
	csocket.send(sout)
	csocket.send(endl)
