#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
#--------------------------------------------------------------
# Mark5cEmu -- A Haystack Mark5C command emulator and remapper
#
# Author:  Jan Wagner, Metsahovi Radio Observatory/TKK
# License: GPU GPL
#
#--------------------------------------------------------------
# <mark5cEmuHelpers.py> : a little collection of helper funcs
#--------------------------------------------------------------

def hexstr2charstr(hexstr):
	instr  = hexstr.expandtabs()
	instr  = instr.replace('-', '');
	instr  = instr.replace(' ', '');
	outstr = ""
	for i in range(0, len(instr)-1, 2):
		decval = int(instr[i:(i+2)], 16)
		outstr = outstr + chr(decval)
	return outstr

str2hexstr = lambda x:"".join([hex(ord(c))[2:].zfill(2) for c in x])

# Testing:
#
# inp = "2020 87 23 87-22"
# fwd = hexstr2charstr(inp)
# bck = str2hexstr(fwd)
# print inp
# print fwd
# print bck
