#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
#--------------------------------------------------------------
# Mark5cEmu -- A Haystack Mark5C command emulator and remapper
#
# Author:  Jan Wagner, Metsahovi Radio Observatory/TKK
# License: GPU GPL
#
#--------------------------------------------------------------
# <mark5cEmuClienthandler.py> : reads new commands from the
# client socket connection, cleans them up and tries
# to map commands into function calls
#--------------------------------------------------------------

import socket
import sys
import threading
minCmdLength = 3

from mark5cEmuInnerstate import *
from mark5cEmuInfocommands import *
class CmdType:
	Call, Query = range(2)

# endl = ' ;\r\n'
endl = ' ;\n'

# Build the list of supported commands 
# Each list element has {string, type, minimum nr of args, function to call}
def assembleCommandMap(l):
	l.append(('bank_info', 	CmdType.Query,  0,  bank_infoQ))
	l.append(('bank_set',  	CmdType.Call,   1,  bank_setX))
	l.append(('bank_set',  	CmdType.Query,  0,  bank_setQ))
	l.append(('mac_list',  	CmdType.Call,   1,  mac_listX))
	l.append(('mac_list',  	CmdType.Query,  0,  mac_listQ))
	l.append(('vsn',       	CmdType.Call,   1,  vsnX))	
	l.append(('vsn',       	CmdType.Query,  0,  vsnQ))
	l.append(('dir_info',  	CmdType.Query,  0,  dir_infoQ))
	l.append(('disk_model', CmdType.Query,  0,  disk_modelQ))
	l.append(('disk_serial',CmdType.Query,  0,  disk_serialQ))
	l.append(('disk_size', 	CmdType.Query,  0,  disk_sizeQ))
	l.append(('status', 	CmdType.Query,  0,  statusQ))
	l.append(('dts_id', 	CmdType.Query,  0,  dts_idQ))
	l.append(('os_rev', 	CmdType.Query,  0,  os_revQ))
	l.append(('os_rev1', 	CmdType.Query,  0,  os_revQ))
	l.append(('os_rev2', 	CmdType.Query,  0,  os_revQ))
	l.append(('protect', 	CmdType.Call,   1,  protectX))
	l.append(('protect', 	CmdType.Query,	0,  protectQ))
	l.append(('reset', 		CmdType.Call,   0,  resetX))
	l.append(('ss_rev',    	CmdType.Query,  0,  ss_revQ))
	l.append(('ss_rev1',   	CmdType.Query,  0,  ss_revQ))
	l.append(('ss_rev2',   	CmdType.Query,  0,  ss_revQ))
	l.append(('get_stats',	CmdType.Query,	0, 	get_statsQ))
	l.append(('record',		CmdType.Call,	1,	recordX))
	l.append(('record',		CmdType.Query,	0,	recordQ))
	l.append(('mode',		CmdType.Query,	0,	modeQ))
	l.append(('mode',		CmdType.Call,	1,	modeX))
	l.append(('play_rate',	CmdType.Query,	0,	play_rateQ))
	l.append(('play_rate',	CmdType.Call,	1,	play_rateX))
	l.append(('scan_set',	CmdType.Query,	0,	scan_setQ))
	l.append(('scan_set',	CmdType.Call,	1,	scan_setX))
	l.append(('position',	CmdType.Query,	0,	positionQ))
	l.append(('pointers',	CmdType.Query,	0,	pointersQ))
	l.append(('port_list',	CmdType.Call,	1,	port_listX))
	l.append(('port_list',	CmdType.Query,	0,	port_listQ))
	l.append(('scan_check',	CmdType.Query,	0,	scan_checkQ))
	l.append(('scan_check',	CmdType.Call,	1,	scan_checkQ)) # alias to scan_checkQ
	l.append(('rtime',		CmdType.Query,	0,	rtimeQ))

# Read commands from the client and act on them
class ClientThread(threading.Thread):

	def __init__ (self, sock, connection, address):
		self.sock           = sock
		self.connection     = connection
		self.address        = address
		self.commandmapping = []
		self.innerstate     = Innerstate()
		threading.Thread.__init__(self)

	def run (self):

		endofworld = False
		print "I SEZ HAI TO ", self.connection.getpeername()
		assembleCommandMap(self.commandmapping)

		sfile = self.sock.makefile()
		while not endofworld:

			# get new command(s) and clean them up
			commands = ""
			commands = self.connection.recv(4096)  # sfile.readline() => Transport endpoint not connected
			print "\tRXED LINE <" + commands.replace('\r','\\r').replace('\n','\\n').replace('\t','\\t') + ">"
			if not commands:
				break
			commands.expandtabs()
			commands = commands.replace(' ', '')
			commands = commands.lower()
			commands = commands.strip()
			if (len(commands) <= 0):
				self.connection.send('\n')
				continue

			# preprocess the command(s) and their args
			while (commands[-1] == ';'):
				commands = commands[:-1].strip()
			commandlist = commands.split(';')
			for command in commandlist:

				cmdType  = CmdType.Query
				cmdName  = command.strip()
				cmdSep   = ''
				cmdArgs  = ''
				if ((cmdName.find("exterminateannihilatedestroy") >= 0) or (cmdName == 'ead')):
					endofworld = True
					continue
				if (command.find('?') >= 0):
					[cmdName, cmdSep, cmdArgs] = command.partition('?')
					cmdType = CmdType.Query
				elif (command.find('=') >= 0):
					[cmdName, cmdSep, cmdArgs] = command.partition('=')
					cmdType = CmdType.Call
				elif (len(cmdName) <= 0):
					self.connection.send('!na? 0 : ok ' + endl)
					# self.connection.send('\n')
					print "\tI HAZ EMPYT COMMAND"
				else:
					print "\tO NOES, BAD CMD FORMAT! : '" + cmdName + "'"
					self.connection.send('!' + cmdName + ' 3 : Must have \'=\' or \'?\' ' + endl)
					continue
	
				cmdName = cmdName.strip()
				cmdArgList = cmdArgs.strip().split(':')
				if (len(cmdArgList)==1 and len(cmdArgList[0])==0):
					cmdArgList=''
				if not (len(cmdName) >= minCmdLength):
					continue

				# send a 'command echo' response
				print "\tI HAZ COMMAND", cmdName, 'TYPUS', cmdType, "WIZ ARGZ '", cmdArgList, "'"
				self.connection.send('!' + cmdName + cmdSep + ' ')
				
				# map the command to a function and call it
				foundcmd = False;
				for cmd in self.commandmapping:
					c_name = cmd[0]
					c_type = cmd[1]
					c_argc = cmd[2]
					c_func = cmd[3]
					m_argc = len(cmdArgList)
					if (cmdName == c_name) and (cmdType == c_type):
						foundcmd = True
						print "\tAWSUM, FOUND CMD :)"
						if (c_argc==0 and m_argc==0) or (m_argc>=c_argc):
							rc = c_func(self.connection, self.innerstate, cmdArgList)
							if rc==False:
								self.connection.send('7 : insufficient or wrong args' + endl)							
						else:
							self.connection.send('7 : insufficient or wrong args' + endl)
						break
				if not foundcmd:
					print "\tO NOES, UNKWON CMD!!"
					self.connection.send('7 : unknown command' + endl)

		print "KTHXBYE"
		self.connection.close()
