#!/usr/bin/python
# -*- coding: iso-8859-1 -*-
#--------------------------------------------------------------
# Mark5cEmu -- A Haystack Mark5C command emulator and remapper
#
# Author:  Jan Wagner, Metsahovi Radio Observatory/TKK
# License: GPU GPL
#
#--------------------------------------------------------------
# <mark5cEmu.py> : starts a server on the TCP port 2620 
# and listens for incoming client connections. A client 
# handler thread is started for every new client.
#--------------------------------------------------------------

import socket
import sys
import threading

from mark5cEmuClienthandler import *

# listen on 'any:2620'
myPort = 2620

keepRunning = True
s = None
try:
	s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
	s.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
	s.bind(('', myPort))
	s.listen(5)
except socket.error, (value,message):
	if s:
		s.close()
	print "Could not open socket and bind port " + str(myPort) + " : " + message
	sys.exit(1) 

# handle the clients
print "listening to the clients on port " + str(myPort)
while keepRunning:
	connection, address = s.accept()
	ClientThread(s, connection, address).start()
s.close()
