
function vdif_packetizer_v14_config(this_block)

  % Revision History:
  %
  %   12-May-2009  (15:24 hours):
  %     Original code was machine generated by Xilinx's System Generator after parsing
  %     C:\ibob-jw\training\vdif_packetizer_v14.vhd
  %
  %

  this_block.setTopLevelLanguage('VHDL');

  this_block.setEntityName('vdif_packetizer_v14');

  % System Generator has to assume that your entity  has a combinational feed through; 
  %   if it  doesn't, then comment out the following line:
  this_block.tagAsCombinational;

  this_block.addSimulinkInport('rst');
  this_block.addSimulinkInport('enable');
  this_block.addSimulinkInport('data_in');
  this_block.addSimulinkInport('data_valid');
  this_block.addSimulinkInport('epseconds');
  this_block.addSimulinkInport('epoch');
  this_block.addSimulinkInport('bitspersample');
  this_block.addSimulinkInport('log2channels');
  this_block.addSimulinkInport('complex');
  this_block.addSimulinkInport('thread_id');
  this_block.addSimulinkInport('station_id');
  this_block.addSimulinkInport('dw64_per_frame');

  this_block.addSimulinkOutport('dbg_dw64counter');
  this_block.addSimulinkOutport('dbg_fifo_empty');
  this_block.addSimulinkOutport('tx_data');
  this_block.addSimulinkOutport('tx_valid');
  this_block.addSimulinkOutport('tx_end_of_frame');
  this_block.addSimulinkOutport('tx_discard');

  dbg_dw64counter_port = this_block.port('dbg_dw64counter');
  dbg_dw64counter_port.setType('UFix_10_0');
  dbg_fifo_empty_port = this_block.port('dbg_fifo_empty');
  dbg_fifo_empty_port.setType('UFix_1_0');
  dbg_fifo_empty_port.useHDLVector(false);
  tx_data_port = this_block.port('tx_data');
  tx_data_port.setType('UFix_64_0');
  tx_valid_port = this_block.port('tx_valid');
  tx_valid_port.setType('UFix_1_0');
  tx_valid_port.useHDLVector(false);
  tx_end_of_frame_port = this_block.port('tx_end_of_frame');
  tx_end_of_frame_port.setType('UFix_1_0');
  tx_end_of_frame_port.useHDLVector(false);
  tx_discard_port = this_block.port('tx_discard');
  tx_discard_port.setType('UFix_1_0');
  tx_discard_port.useHDLVector(false);

  % -----------------------------
  if (this_block.inputTypesKnown)
    % do input type checking, dynamic output type and generic setup in this code block.

    if (this_block.port('rst').width ~= 1);
      this_block.setError('Input data type for port "rst" must have width=1.');
    end

    this_block.port('rst').useHDLVector(false);

    if (this_block.port('enable').width ~= 1);
      this_block.setError('Input data type for port "enable" must have width=1.');
    end

    this_block.port('enable').useHDLVector(false);

    if (this_block.port('data_in').width ~= 64);
      this_block.setError('Input data type for port "data_in" must have width=64.');
    end

    if (this_block.port('data_valid').width ~= 1);
      this_block.setError('Input data type for port "data_valid" must have width=1.');
    end

    this_block.port('data_valid').useHDLVector(false);

    if (this_block.port('epseconds').width ~= 30);
      this_block.setError('Input data type for port "epseconds" must have width=30.');
    end

    if (this_block.port('epoch').width ~= 6);
      this_block.setError('Input data type for port "epoch" must have width=6.');
    end

    if (this_block.port('bitspersample').width ~= 5);
      this_block.setError('Input data type for port "bitspersample" must have width=5.');
    end

    if (this_block.port('log2channels').width ~= 5);
      this_block.setError('Input data type for port "log2channels" must have width=5.');
    end

    if (this_block.port('complex').width ~= 1);
      this_block.setError('Input data type for port "complex" must have width=1.');
    end

    this_block.port('complex').useHDLVector(false);

    if (this_block.port('thread_id').width ~= 10);
      this_block.setError('Input data type for port "thread_id" must have width=10.');
    end

    if (this_block.port('station_id').width ~= 16);
      this_block.setError('Input data type for port "station_id" must have width=16.');
    end

    if (this_block.port('dw64_per_frame').width ~= 10);
      this_block.setError('Input data type for port "dw64_per_frame" must have width=10.');
    end

  end  % if(inputTypesKnown)
  % -----------------------------

  % -----------------------------
   if (this_block.inputRatesKnown)
     setup_as_single_rate(this_block,'clk','ce')
   end  % if(inputRatesKnown)
  % -----------------------------

  % (!) Custimize the following generic settings as appropriate. If any settings depend
  %      on input types, make the settings in the "inputTypesKnown" code block.
  this_block.addGeneric('frameLenLimit','integer','2048');
  this_block.addGeneric('frameCountLimit','integer','67108864');

  % Add addtional source files as needed.
  %  |-------------
  %  | Add files in the order in which they should be compiled.
  %  | If two files "a.vhd" and "b.vhd" contain the entities
  %  | entity_a and entity_b, and entity_a contains a
  %  | component of type entity_b, the correct sequence of
  %  | addFile() calls would be:
  %  |    this_block.addFile('b.vhd');
  %  |    this_block.addFile('a.vhd');
  %  |-------------

  %    this_block.addFile('');
  %    this_block.addFile('');
  this_block.addFile('simpleFIFO.vhdl');
  this_block.addFile('vdif_packetizer_v14.vhdl');

return;


% ------------------------------------------------------------

function setup_as_single_rate(block,clkname,cename) 
  inputRates = block.inputRates; 
  uniqueInputRates = unique(inputRates); 
  if (length(uniqueInputRates)==1 & uniqueInputRates(1)==Inf) 
    block.setError('The inputs to this block cannot all be constant.'); 
    return; 
  end 
  if (uniqueInputRates(end) == Inf) 
     hasConstantInput = true; 
     uniqueInputRates = uniqueInputRates(1:end-1); 
  end 
  if (length(uniqueInputRates) ~= 1) 
    block.setError('The inputs to this block must run at a single rate.'); 
    return; 
  end 
  theInputRate = uniqueInputRates(1); 
  for i = 1:block.numSimulinkOutports 
     block.outport(i).setRate(theInputRate); 
  end 
  block.addClkCEPair(clkname,cename,theInputRate); 
  return; 

% ------------------------------------------------------------

