/*************************************************
 *                                               *
 * VDIF Dump for data analysis                   *
 *                                               *
 *************************************************/

#include "libvdif.h"
#define _GNU_SOURCE 1
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#define _XOPEN_SOURCE 500
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#define VDIFDMP_VER_STR "VDIF Dump Version 1.0"
#define VDIFDMP_CPY_STR "(C) 2009 Jan Wagner, GNU GPL v3"

#define VLEVEL(v,x) do{if(verbosity>=v){x;}}while(0)
typedef unsigned long long ull_t;

void dump_bytes(off64_t, const unsigned char*);

void print_usage() 
{
   printf(" Usage: vdif_dump [-vvv] file\n\n"
          "    -v   : increase the verbosity level\n"
          "    file : the input file\n\n");
}

int main(int argc, char* argv[]) 
{
   char frame[1024];

   char* filename;
   off64_t framecount = 0, readpos = 0, second = 0, framenr = 0;
   int verbosity;
   int fd;

   /* command line arguments */
   printf("\n %s\n %s\n\n", VDIFDMP_VER_STR, VDIFDMP_CPY_STR);
   if (argc < 2) {
      print_usage(); 
      return 0;
   }
   verbosity = 0;
   if (argc > 2) {
      filename = argv[2];
      if (argv[1][0] != '-' && argv[1][1] != 'v') {
         printf("Arg 1 '%s' not '-v[vv]'\n", argv[1]);
         return -1;
      }
      while (argv[1][verbosity+1] == 'v') verbosity++;
   } else {
      filename = argv[1];
   }
   printf("Verbosity: %d\n", verbosity);
   
   /* open the file */
   fd = open(filename, O_RDONLY);
   if (fd < 0) {
      printf("Could not open file: '%s'\n", strerror(errno)); 
      return -1;
   }

   /* scan the headers plus a little bit of payload data */
   while (1) {
      ssize_t n;
      off64_t framelength, curr_second;
      unsigned char* payload;

      // read header + some data
      n = pread(fd, frame, sizeof(frame), readpos); 
      if (n < 16) { break; }

      // analysis
      payload     = (unsigned char*)vdif_get_payload(frame);
      framelength = vdif_get_framelength(frame);
      framenr     = vdif_get_framenumber(frame);
      curr_second = vdif_get_seconds(frame);
      readpos    += 8*framelength;
      if (curr_second > second) {
         second = curr_second;
         VLEVEL(0, printf("Second %Lu next frame at byte 0x%08llX, intra-sec frame #%Lu\n", \
                    (ull_t)second, (ull_t)readpos, (ull_t)framenr) );
      }
      VLEVEL(1, print_vdif(stdout, (vdifheader_t*)frame));
      VLEVEL(2, dump_bytes(framenr, payload));

      framecount++;
   }
   close(fd);

   printf("File had %Lu frames.\n", (unsigned long long)framecount);

   return 0;
}

void dump_bytes(off64_t line, const unsigned char* data)
{
   printf(" %012Lu"
          " : %02x %02x %02x %02x"
          " : %02x %02x %02x %02x"
          " : %02x %02x %02x %02x ; d=%d\n",
            (ull_t)line,
            *(data+0), *(data+1), *(data+2), *(data+3),
            *(data+4), *(data+5), *(data+6), *(data+7),
            *(data+8), *(data+9), *(data+10), *(data+11),
            *(data+10) - *(data+11) );
   return;
}
