#ifndef PARSE_EVN_FILENAME
#define PARSE_EVN_FILENAME

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <time.h>
#include <sys/time.h>
#include <math.h>
#define _GNU_SOURCE
#include <string.h>

struct evn_filename {
	char    *exp_name;
	char    *station_code;
	char    *scan_name;
	char    *data_start_time_ascii;
	double   data_start_time;         /* system tick seconds time_t (integer) or with fractional seconds (double) */
	char   **auxinfo;                 /* pointer to (array of pointers to aux info elements) */
	int      nr_auxinfo;
	char    *file_type;
    char     valid;
};

struct evn_filename *parse_evn_filename(char *filename);

char *get_aux_entry(char *key, char **auxinfo, int nr_auxinfo);

#endif

/*
 * $Log: parse_evn_filename.h,v $
 * Revision 1.1  2007/09/03 14:15:01  jwagner
 * first improved dstart2.c program based on rttsunamid EVN filename parser
 *
 *
 */ 


