// cIOLine.hh -- an abstract class for handling I/O lines.
// $Id: cIOLine.hh,v 1.6 2002/12/18 07:29:43 amn Exp $
// Copyright (C) 1995 Ari Mujunen. (amn@nfra.nl, Ari.Mujunen@hut.fi)

// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License.
// See the file 'COPYING' for details.

/*
 * $Log: cIOLine.hh,v $
 * Revision 1.6  2002/12/18 07:29:43  amn
 * Upped revision.
 *
 * Revision 1.2  2002/12/18 07:29:42  amn
 * intermediate
 *
 * Revision 1.1  2002/12/18 07:23:46  amn
 * Recovered from /home disk crash by re-creating 'common' module in CVS.
 *
 * Revision 1.5  1998/05/29 05:51:01  amn
 * Comment leader of log lines changed.
 *
 * Revision 1.4  1997/03/11 08:16:18  amn
 * Changed storing the pathname from C++ String into char *.
 * Added 'whatPathname()' query method.
 *
 * Revision 1.3  1995/06/18 15:10:56  amn
 * A destructor added.
 *
 * Revision 1.2  1995/06/16  15:12:35  amn
 * '.h' -> '.hh' for C++ headers.
 *
 * Revision 1.1  1995/02/11  19:53:06  amn
 * Initial revision
 */


#ifndef _cIOLine_hh
#ifdef __GNUG__
#pragma interface
#endif
#define _cIOLine_hh 1

#include "registration.h"
RCSID(cIOLine_hh, "$Id: cIOLine.hh,v 1.6 2002/12/18 07:29:43 amn Exp $");

#include <stdlib.h>  // for 'free()'

class cIOLine
{
protected:
  int fileDesc;  // as returned by 'open()'
  char *rememberedPathname;
public:
  cIOLine() {
    fileDesc = -1;
    rememberedPathname = NULL;
  }
  virtual ~cIOLine() {
    if (rememberedPathname) {
      free(rememberedPathname);
    }
  }
  virtual void open(const char *pathName);
  virtual char *whatPathname(void);
  virtual void defaultSettings(void);
  virtual void close(void);
};  // class cIOLine

#endif
