// cIOLine.cc -- an abstract class for handling I/O lines.
// $Id: cIOLine.cc,v 1.8 2002/12/18 07:29:06 amn Exp $
// Copyright (C) 1995 Ari Mujunen. (amn@nfra.nl, Ari.Mujunen@hut.fi)

// This is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License.
// See the file 'COPYING' for details.

// $Log: cIOLine.cc,v $
// Revision 1.8  2002/12/18 07:29:06  amn
// Upped revision.
//
// Revision 1.2  2002/12/18 07:29:05  amn
// intermediate
//
// Revision 1.1  2002/12/18 07:23:46  amn
// Recovered from /home disk crash by re-creating 'common' module in CVS.
//
// Revision 1.7  1998/11/18 12:48:33  jen
// Adapted for glibc6 (hamm).
//
// Revision 1.6  1997/03/11 13:45:56  amn
// Made I/O line device file open error message clear ('strerr()').
//
// Revision 1.5  1997/03/11 08:16:59  amn
// Changed stored pathname from C++ String into char*.
// Added 'whatPathname()' query method.
//
// Revision 1.4  1995/06/18 15:10:19  amn
// Oops, 'open()' didn't close the old 'fileDesc' first.
//
// Revision 1.3  1995/06/16  15:09:48  amn
// '.h' -> '.hh' for C++ headers.
//
// Revision 1.2  1995/03/30  11:08:51  amn
// 'close()' is successful when it returns ==0 (not != -1).
//
// Revision 1.1  1995/02/11  19:41:43  amn
// Initial revision
//

#include "registration.h"
RCSID(cIOLine_cc, "$Id: cIOLine.cc,v 1.8 2002/12/18 07:29:06 amn Exp $");


#pragma implementation
#include "cIOLine.hh"

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>  // for 'fprintf()'
#include <errno.h>
#include <string.h>
#include <assert.h>


void
cIOLine::open(const char *pathName)
{
  if (fileDesc != -1) {
    close();
  }
  if ( (fileDesc = ::open(pathName, O_RDWR | O_NOCTTY)) == -1 ) {
    char *err = strerror(errno);

    fprintf(stderr, "open(\"%s\"): %s\n",
	    pathName, err);
    assert (fileDesc != -1);  // terminate with line number info
  }
    // As long as we rely on termios' cc[VTIME] timeout mechanism,
    // 'O_NONBLOCK' should not be specified.
  this->rememberedPathname = strdup(pathName);
  this->defaultSettings();
}  // open

// This returns access to the stored pathname of the opened device file.
char *
cIOLine::whatPathname(void)
{
  return(this->rememberedPathname);
}  // whatPathname

// This finalizes line settings just after opening a file descriptor.
// Most inheritors will want to supply a version that more accurately
// sets the required defaults.
void
cIOLine::defaultSettings(void)
{
}  // defaultSettings

void
cIOLine::close(void)
{
  int retCodeFromClose;

  if (fileDesc == -1) {
    return;
  }
  assert((retCodeFromClose = ::close(fileDesc)) == 0);
  fileDesc = -1;
  if (rememberedPathname) {
    free(rememberedPathname);
  }
  rememberedPathname = NULL;
}  // close
