/*************************************************
 *                                               *
 * Send commands to the iBob                     *
 *                                               *
 * Usage: control ip cmd addr [data]             *
 *                                               *
 *   ip   : ip of the iBob                       *
 *   cmd  : command type (0=read, 1=write)       *
 *   addr : iBob PLB bus address                 *
 *   data : 32-bit value to write to addr        *
 *                                               *
 *************************************************/

#include "ibobcontrol.h"

int main(int argc, char* argv[]) 
{
  char*          ibob_ip;
  ibobcontrol_t  config;
  ibobquery_t    query;
  ibobresponse_t response;

  /* Info */
  if (argc < 3) {
     printf( "\n %s     %s\n\n", VER_STR, CPY_STR);
     printf( " Usage: control ip cmd addr [value]\n\n"
             "   ip    : IP address of your iBob\n"
             "   cmd   : command type (0=read, 1=write, ...)\n"
             "   addr  : the 32-bit PLB bus address to read from\n"
             "   value : the single 32-bit data value to write\n\n"
             " Address and data can be specified in decimal (123) or hex (0x7B)\n\n");
     return 0;
  }

  /* Get and convert user params */
  ibob_ip = argv[1];
  query.command = atol(argv[2]);
  if (argv[3][1] == 'x') {
     sscanf(argv[3], "0x%x", &query.address);
  } else {
     query.address = atol(argv[3]);
  }
  if (argc > 4) {
     if (argv[4][1] == 'x') {
        sscanf(argv[4], "0x%x", &query.value);
     } else {
        query.value = atol(argv[4]);
     }
  }

  /* Prepare */
  if (ibobcontrol_open(&config) != 0)
     return -1;

  /* Query */
  if (ibobcontrol_query(ibob_ip, &config, &query, &response) > 0) {
      size_t i;
      fprintf(stderr, "Received reply: ");
      for (i = 0; i < response.length; i++ ) {
         fprintf(stderr, "0x%02x ", (unsigned int)(response.data[i]) & 0xFF);
      }
      fprintf(stderr, "\n");
  }

  /* Done */
  ibobcontrol_close(&config);

  return 0;
}
