--
-- (C) 2009 Jan Wagner
--
-- Based on the simpleFIFO example from 
-- http://www.missiontech.co.nz/index.php?page=vhdl
-- which was _not_ a FIFO and not even simple ;-)
--

library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity simpleFIFO is
  generic (
    width : integer := 8;
    depth : integer := 10
  );
  port (
    clk   : in std_logic;
    ce    : in std_logic;
    rst   : in std_logic;
    
    wr_en : in std_logic;
    rd_en : in std_logic;
    din   : in std_logic_vector(width-1 downto 0);
    dout  : out std_logic_vector(width-1 downto 0);
    full  : out std_logic;
    empty : out std_logic;
    valid : out std_logic;
    debug : out std_logic_vector(31 downto 0)
  );
end simpleFIFO;

architecture behavioral of simpleFIFO is

  type vector_array is array (0 to depth+1) of std_logic_vector(width-1 downto 0);
  signal memory : vector_array;

begin

  fifo_proc: process(clk, rst)
    variable rd_addr_v  : integer range 0 to depth+1;
    variable wr_addr_v  : integer range 0 to depth+1;
    variable count_v    : integer range 0 to depth+1;
    variable empty_v    : std_logic;
    variable full_v     : std_logic;
  begin

    if rst = '1' then
        full      <= '0';
        empty     <= '1';
        empty_v   := '1';
        full_v    := '0';
        count_v   := 0;
        rd_addr_v := 0;
        wr_addr_v := 0;
    else
        if rising_edge(clk) then
            -- full?
            if count_v = depth then
                full_v := '1';
            else
                full_v := '0';
            end if;
            -- empty?
            if count_v = 0 then
                empty_v := '1';
            else
                empty_v := '0';
            end if;
            -- write to non-full
            if (wr_en = '1' and full_v = '0') then
                memory(wr_addr_v) <= din;
                if wr_addr_v = depth+1 then
                    wr_addr_v := 0;
                else
                    wr_addr_v := wr_addr_v + 1;
                end if;
                count_v := count_v + 1;
            end if;
            -- read from non-empy
            if (rd_en = '1' and empty_v = '0') then
                dout <= memory(rd_addr_v);
                if rd_addr_v = depth + 1 then
                    rd_addr_v := 0;
                else
                    rd_addr_v := rd_addr_v + 1;
                end if;
                count_v := count_v - 1;
                valid <= '1';
            else
                -- data is "valid" only for one cycle after rd_en
                valid <= '0';
            end if;
        end if; -- rising_edge(clk)
    end if; -- async reset
    empty <= empty_v;
    full  <= full_v;
    debug <= std_logic_vector(to_unsigned(count_v, debug'length));
  end process fifo_proc;

end behavioral;
