#ifndef IBOBVDIFCLIENT_H
#define IBOBVDIFCLIENT_H

#define _GNU_SOURCE

/////////////////////////////////////////////////
// Includes
/////////////////////////////////////////////////

#include <memory.h>
#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <fcntl.h>
#include <unistd.h>
#include <sys/mman.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/types.h>

#define __USE_GNU
#include <sched.h>
#undef __USE_GNU
#include <pthread.h>
#include <limits.h>

#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>

#include <signal.h>

/////////////////////////////////////////////////
// Definitions
/////////////////////////////////////////////////

#define MAX_UDP_SIZE      32768

#define EXIT_OK           0
#define EXIT_ERROR        1
#define EXIT_FILE_ERROR   2
#define EXIT_NET_ERROR    3

#define MIN(a,b) (a<b) ? a : b

typedef unsigned long long ull_t;

// -- global UDP VDIF receiver settings
typedef struct settings_tt {
   int          port;
   off64_t      final_size;
   const char*  filename;
   off64_t      base_seconds;
   u_int32_t    previous_vdif_second;
   int          file_fd;
   int          size_type;
   int          socket_fd;
   vdifheader_t *vdif;
   char         *datagram;
} settings_t;

#define TYPE_BYTES 0
#define TYPE_SECONDS 1
#define TYPE_INFINITE 2

// -- performance counters
typedef struct counters_tt {
   struct timeval start;
   struct timeval stop;
   off64_t        vdif_seconds_first;
   off64_t        vdif_seconds_last;
   off64_t        bytes;
   off64_t        packets;
   size_t         smallest_udp;
   size_t         largest_udp;
} counters_t;

// -- set of performance counters
typedef struct transfer_stats_tt {
   counters_t total;
   counters_t interval;
} transfer_stats_t;

#endif // IBOBVDIFCLIENT_H
