#ifndef IBOBCONTROL_H
#define IBOBCONTROL_H

/***************************************************
 **                                               **
 ** iBobControl                                   **
 **                                               **
 ** A "library" for sending commands to the iBob  **
 ** and waiting for a response, with timeout.     **
 **                                               **
 **************************************************/

///////////////////////////////////////////////////
// Declarations
///////////////////////////////////////////////////

#define VER_STR "iBob Control Version 1.0"
#define CPY_STR "(C) 2009 Jan Wagner, GNU GPL v3"

#define IBOB_CTRL_PORT   46229   // default port on the iBob
#define IBOB_TIMEOUT_SEC 1       // seconds until respose timeout
#define IBOB_MAX_DGRAM_SIZE 8*4  // 8 x uint32

///////////////////////////////////////////////////
// Includes
///////////////////////////////////////////////////

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include <fcntl.h>
#include <unistd.h>

#include <sys/mman.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>

#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>

///////////////////////////////////////////////////
// Data types
///////////////////////////////////////////////////

// general 'setup' structure used for API calls
typedef struct ibobcontrol_tt {
   int    socket_fd;
   fd_set read_set;
   struct sockaddr_in client_addr;
   struct timeval     read_timeout;
} ibobcontrol_t;

// container for data sent to the iBob
typedef struct ibobquery_tt {
   u_int32_t command, address, value;
} ibobquery_t;

// container for response data received from the iBob
typedef struct ibobresponse_tt {
   size_t length;
   char   data[IBOB_MAX_DGRAM_SIZE];
} ibobresponse_t;


///////////////////////////////////////////////////
// API Function declarations
///////////////////////////////////////////////////

int ibobcontrol_open(ibobcontrol_t*);
int ibobcontrol_query(const char*, ibobcontrol_t*, ibobquery_t*, ibobresponse_t*);
int ibobcontrol_close(ibobcontrol_t*);

#endif // IBOBCONTROL_H
