#!/bin/bash
#
# Set the iBOB clock to computer/NTP seconds count
# Write station code 'Mh' into the config word
#

IIP=193.166.42.12   # the IP address of the iBob

#---------------------------------------------------
# IBOB % listdev
# Address map :
#        0xD0000000 -> National Semi PLL
#        0xD0000100 -> adc_data_i
#        0xD0000200 -> adc_data_q
#        0xD0000300 -> bit_levels
#        0xD0000400 -> config
#        0xD0000500 -> dest_ip
#        0xD0000600 -> dest_port
#        0xD0000700 -> dest_port_offset
#        0xD0000800 -> rtc_settime
#        0xD0000900 -> rtc_starttime
#        0xD0000A00 -> rtc_stoptime
#        0xD0000B00 -> rtc_time
#        0xD1000000 -> status
#        0xD1000100 -> vdif_framelen_w64
#---------------------------------------------------

REG_CONFIG=0xD0000400  # config
REG_SETTIME=0xD0000800 # rtc_settime
REG_TIME=0xD0000B00    # rtc_time
CMD_RD=0
CMD_WR=1

#---------------------------------------------------

echo "Current iBOB seconds counter:"
./control $IIP $CMD_RD $REG_TIME

echo "Writing NTP time into iBob:"
./control $IIP $CMD_WR $REG_SETTIME `date -u +%s`

  # Use 'config' register to reload the clock counter
  #   value 0x014D6809 = 01='2-bit' 4D='M' 68='h' | bit3=samplesource#real bit0=reloadclock
  #   value 0x014D6808 = 01='2-bit' 4D='M' 68='h' | bit3=samplesource#real
./control $IIP $CMD_WR $REG_CONFIG 0x014D6809
./control $IIP $CMD_WR $REG_CONFIG 0x014D6808

echo 
echo "Current iBOB seconds counter:"
./control $IIP $CMD_RD $REG_TIME
sleep 2

echo
echo "Current iBOB seconds counter:"
./control $IIP $CMD_RD $REG_TIME
