#!/bin/sh

iface=eth2

if [ "$1" = "arp" ]; then
	tcpdump -ennqti ${iface} \( arp or icmp \)
	exit
fi

if [ "$1" = "eth" ]; then
	# generate:
	# hping3 -V --udp -i u500000 193.166.42.11
	# get:
	tcpdump -nlei ${iface} -s9000 -xx -vvv ether src host BA:DC:AF:E4:BE:E0
	exit
fi

if [ "$1" = "udp" ]; then
	tcpdump -v -XX -s 96 -nleqti ${iface} \( udp \)
	exit
fi

if [ "$1" = "multi" ]; then
	tcpdump -v -XX -s 96 -nleqti ${iface} \(multicast and not arp\)
	exit
fi

if [ "$1" = "udpplain" ]; then
	tcpdump -X -s 96 -nei ${iface} \( udp \)
	exit
fi

echo "./dump.sh [arp|eth|udp|udpplain|multi]"
