
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Slatec;

@EXPORT_OK  = qw( eigsys matinv fft fftb svdc poco geco gefa podi gedi rs ezffti ezfftf ezfftb );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;
@ISA    = qw( PDL::Exporter DynaLoader );

bootstrap PDL::Slatec;

=head1 NAME

PDL::Slatec -- PDL interface to the slatec numerical programming library

=head1 DESCRIPTION

This module serves the dual purpose of showing how to interface
PDL to an external library and providing various functions to 
interface to the slatec library. In due time, reasonable 
perl functions will be provided to take advantage of all 
the library but currently we only have

=head1 SYNOPSIS

 use PDL::Slatec;

=head1 FUNCTIONS

=head2 eigsys

=for ref

Eigenvalues and eigenvectors of a real positive definite symmetric matrix.

=for usage

($eigvals,$eigvecs) = eigsys($mat)

Note: this function should be extended to calculate only eigenvalues if called in
scalar context!

=head2 matinv

=for ref

Inverse of a square matrix

=for usage

 ($inv) = matinv($mat)


Using this library requires a fortran compiler. The source for the routines
is provided for convenience.

=head1 AUTHOR

Copyright (C) 1997 Tuomas J. Lukka. 
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL 
distribution. If this file is separated from the PDL distribution, 
the copyright notice should be included in the file.



=cut






=head1 FUNCTIONS



=cut





use PDL::Core;
use PDL::Basic;
use PDL::Primitive;

# Note: handles only real symmetric positive-definite.

*eigsys = \&PDL::eigsys;

sub PDL::eigsys {
	my($h) = @_;
	$h = float($h);
	rs($h, 
		(my $eigval=PDL->null),
		(long (pdl (1))),(my $eigmat=PDL->null),
		(my $fvone = PDL->null),(my $fvtwo = PDL->null),
		(my $errflag=PDL->null)
	);
#	print $covar,$eigval,$eigmat,$fvone,$fvtwo,$errflag;
	if(sum($errflag) > 0) {
		barf("Non-positive-definite matrix given to eigsys: $h\n");
	}
	return ($eigval,$eigmat);
}

*matinv = \&PDL::matinv;

sub PDL::matinv {
	my($m) = @_;
	$m = $m->copy(); # Make sure we don't overwrite :(
	gefa($m,(my $ipvt=null),(my $info=null));
	if(sum($info) > 0) {
		barf("Uninvertible matrix given to inv: $m\n");
	}
	gedi($m,$ipvt,(pdl 0,0),(null),(long( pdl (1))));
	$m;
}

sub prepfft {
	my($n) = @_;
	my $tmp = PDL->zeroes(float(),$n*3+15);
	$n = pdl $n;
	ezffti($n,$tmp);
	return $tmp;
}

*fft = \&PDL::fft;
sub PDL::fft {
	my($v) = @_;
	my $ws = prepfft($v->getdim(0));
	ezfftf($v,(my $az = PDL->null), (my $a = PDL->null), 
		  (my $b = PDL->null), $ws);
	return ($az,$a,$b);
}

sub rfft {
	my($az,$a,$b) = @_;
	my $ws = prepfft($a->getdim(0));
	$v = $a->copy();
	ezfftb($v,$az,$a,$b,$ws);
	return $v;
}





=head2 svdc

=for sig

  Signature: (x(n,p);[o]s(p);[o]e(p);[o]u(n,p);[o]v(p,p);[o]work(n);int job();int [o]info())


=for ref

info not available


=cut




sub PDL::svdc {
		if($#_ == 7 || $#_ == -1 ) { &PDL::_svdc_int; }
		 elsif($#_ == 7) { 
		 	@_ = @_;
		 	$_[7] = $_[7];
$_[6] = $_[6];
$_[5] = $_[5];
$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_svdc_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[7] = PDL->null);
unshift @ret,($_[6] = PDL->null);
unshift @ret,($_[5] = PDL->null);
unshift @ret,($_[4] = PDL->null);
unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_svdc_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for svdc";
		}
		}

*svdc = \&PDL::svdc;




=head2 poco

=for sig

  Signature: (a(n,n);rcond();[o]z(n);int [o]info())


=for ref

info not available


=cut




sub PDL::poco {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_poco_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_poco_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_poco_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for poco";
		}
		}

*poco = \&PDL::poco;




=head2 geco

=for sig

  Signature: (a(n,n);int [o]ipvt(n);[o]rcond();[o]z(n))


=for ref

info not available


=cut




sub PDL::geco {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_geco_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_geco_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_geco_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for geco";
		}
		}

*geco = \&PDL::geco;




=head2 gefa

=for sig

  Signature: (a(n,n);int [o]ipvt(n);int [o]info())


=for ref

info not available


=cut




sub PDL::gefa {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_gefa_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_gefa_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_gefa_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for gefa";
		}
		}

*gefa = \&PDL::gefa;




=head2 podi

=for sig

  Signature: (a(n,n);[o]det(two);int job())


=for ref

info not available


=cut




sub PDL::podi {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_podi_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_podi_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_podi_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for podi";
		}
		}

*podi = \&PDL::podi;




=head2 gedi

=for sig

  Signature: (a(n,n);int [o]ipvt(n);[o]det(two);[o]work(n);int job())


=for ref

info not available


=cut




sub PDL::gedi {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_gedi_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_gedi_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[4] = PDL->null);
unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_gedi_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for gedi";
		}
		}

*gedi = \&PDL::gedi;




=head2 rs

=for sig

  Signature: (a(n,n);[o]w(n);int matz();[o]z(n,n);[t]fvone(n);[t]fvtwo(n);int [o]ierr())


=for ref

info not available


=cut




sub PDL::rs {
		if($#_ == 6 || $#_ == -1 ) { &PDL::_rs_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[6] = $_[4];
$_[5] = PDL->null;
$_[4] = PDL->null;
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_rs_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[6] = PDL->null);
$_[5] = PDL->null;
$_[4] = PDL->null;
unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_rs_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for rs";
		}
		}

*rs = \&PDL::rs;




=head2 ezffti

=for sig

  Signature: (int n();[o]wsave(foo))


=for ref

info not available


=cut




sub PDL::ezffti {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_ezffti_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_ezffti_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_ezffti_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for ezffti";
		}
		}

*ezffti = \&PDL::ezffti;




=head2 ezfftf

=for sig

  Signature: (r(n);[o]azero();[o]a(n);[o]b(n);wsave(foo))


=for ref

info not available


=cut




sub PDL::ezfftf {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_ezfftf_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_ezfftf_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[4] = PDL->null);
unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_ezfftf_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for ezfftf";
		}
		}

*ezfftf = \&PDL::ezfftf;




=head2 ezfftb

=for sig

  Signature: ([o]r(n);azero();a(n);b(n);wsave(foo))


=for ref

info not available


=cut




sub PDL::ezfftb {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_ezfftb_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_ezfftb_int;
		} elsif($#_ == 3) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[4] = PDL->null);
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_ezfftb_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for ezfftb";
		}
		}

*ezfftb = \&PDL::ezfftb;


;
 


# Exit with OK status

1;

