
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Math;

@EXPORT_OK  = qw( acos asin atan cosh sinh tan tanh ceil floor rint pow acosh asinh atanh erf erfc bessj0 bessj1 bessy0 bessy1 bessjn bessyn lgamma erfi eigens simq squaretotri );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;
@ISA    = qw( PDL::Exporter DynaLoader );

bootstrap PDL::Math;

=head1 NAME

PDL::Math - extended mathematical operations for PDL

=head1 SYNOPSIS

 use PDL::Math;
 
 use PDL::Graphics::TriD;
 imag3d [SURF2D,bessj0(rvals(zeroes(50,50))/2)];

=head1 DESCRIPTION

This module extends PDL with more advanced mathematical
functions than provided and standard Perl.


Note all the functions have one input pdl, and one output,  unless otherwise
stated.

The functions are usually available from the system 
maths library, however if they are not (determined
when PDL is compiled) a version from the Cephes math
library is used.

=cut






=head1 FUNCTIONS



=cut






=head2 acos

=for sig

  Signature: (a(); [o]b())

=for ref

Complete the standard trigonometric functions.

=cut




sub PDL::acos {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_acos_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_acos_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_acos_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for acos";
		}
		}

*acos = \&PDL::acos;




=head2 asin

=for sig

  Signature: (a(); [o]b())

=for ref

Complete the standard trigonometric functions.

=cut




sub PDL::asin {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_asin_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_asin_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_asin_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for asin";
		}
		}

*asin = \&PDL::asin;




=head2 atan

=for sig

  Signature: (a(); [o]b())

=for ref

Complete the standard trigonometric functions.

=cut




sub PDL::atan {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_atan_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_atan_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_atan_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for atan";
		}
		}

*atan = \&PDL::atan;




=head2 cosh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic functions.

=cut




sub PDL::cosh {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_cosh_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_cosh_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_cosh_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for cosh";
		}
		}

*cosh = \&PDL::cosh;




=head2 sinh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic functions.

=cut




sub PDL::sinh {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_sinh_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_sinh_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_sinh_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for sinh";
		}
		}

*sinh = \&PDL::sinh;




=head2 tan

=for sig

  Signature: (a(); [o]b())

=for ref

Complete the standard trigonometric functions.

=cut




sub PDL::tan {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_tan_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_tan_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_tan_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for tan";
		}
		}

*tan = \&PDL::tan;




=head2 tanh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic functions.

=cut




sub PDL::tanh {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_tanh_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_tanh_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_tanh_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for tanh";
		}
		}

*tanh = \&PDL::tanh;




=head2 ceil

=for sig

  Signature: (a(); [o]b())

=for ref

Round to integral values in floating-point format

=cut




sub PDL::ceil {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_ceil_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_ceil_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_ceil_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for ceil";
		}
		}

*ceil = \&PDL::ceil;




=head2 floor

=for sig

  Signature: (a(); [o]b())

=for ref

Round to integral values in floating-point format

=cut




sub PDL::floor {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_floor_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_floor_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_floor_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for floor";
		}
		}

*floor = \&PDL::floor;




=head2 rint

=for sig

  Signature: (a(); [o]b())

=for ref

Round to integral values in floating-point format

=cut




sub PDL::rint {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_rint_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_rint_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_rint_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for rint";
		}
		}

*rint = \&PDL::rint;




=head2 pow

=for sig

  Signature: (a(); b(); [o]c())

=for ref

Synonym for `**'

=cut




sub PDL::pow {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_pow_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_pow_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_pow_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for pow";
		}
		}

*pow = \&PDL::pow;




=head2 acosh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic functions.

=cut




sub PDL::acosh {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_acosh_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_acosh_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_acosh_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for acosh";
		}
		}

*acosh = \&PDL::acosh;




=head2 asinh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic functions.

=cut




sub PDL::asinh {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_asinh_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_asinh_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_asinh_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for asinh";
		}
		}

*asinh = \&PDL::asinh;




=head2 atanh

=for sig

  Signature: (a(); [o]b())

=for ref

The standard hyperbolic functions.

=cut




sub PDL::atanh {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_atanh_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_atanh_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_atanh_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for atanh";
		}
		}

*atanh = \&PDL::atanh;




=head2 erf

=for sig

  Signature: (a(); [o]b())

=for ref

The error function

=cut




sub PDL::erf {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_erf_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_erf_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_erf_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for erf";
		}
		}

*erf = \&PDL::erf;




=head2 erfc

=for sig

  Signature: (a(); [o]b())

=for ref

The complement of the error function

=cut




sub PDL::erfc {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_erfc_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_erfc_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_erfc_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for erfc";
		}
		}

*erfc = \&PDL::erfc;




=head2 bessj0

=for sig

  Signature: (a(); [o]b())


=for ref

Standard Bessel Functions



=cut




sub PDL::bessj0 {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_bessj0_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessj0_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_bessj0_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for bessj0";
		}
		}

*bessj0 = \&PDL::bessj0;




=head2 bessj1

=for sig

  Signature: (a(); [o]b())


=for ref

Standard Bessel Functions



=cut




sub PDL::bessj1 {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_bessj1_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessj1_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_bessj1_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for bessj1";
		}
		}

*bessj1 = \&PDL::bessj1;




=head2 bessy0

=for sig

  Signature: (a(); [o]b())


=for ref

Standard Bessel Functions



=cut




sub PDL::bessy0 {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_bessy0_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessy0_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_bessy0_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for bessy0";
		}
		}

*bessy0 = \&PDL::bessy0;




=head2 bessy1

=for sig

  Signature: (a(); [o]b())


=for ref

Standard Bessel Functions



=cut




sub PDL::bessy1 {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_bessy1_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessy1_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_bessy1_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for bessy1";
		}
		}

*bessy1 = \&PDL::bessy1;




=head2 bessjn

=for sig

  Signature: (a(); int n(); [o]b())


=for ref

Standard Bessel Functions

=cut
=pod
This has a second integer
argument which gives the order of the function require.


=cut




sub PDL::bessjn {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_bessjn_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessjn_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessjn_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for bessjn";
		}
		}

*bessjn = \&PDL::bessjn;




=head2 bessyn

=for sig

  Signature: (a(); int n(); [o]b())


=for ref

Standard Bessel Functions

=cut
=pod
This has a second integer
argument which gives the order of the function require.


=cut




sub PDL::bessyn {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_bessyn_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessyn_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_bessyn_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for bessyn";
		}
		}

*bessyn = \&PDL::bessyn;




=head2 lgamma

=for sig

  Signature: (a(); [o]b(); int[o]s())

=for ref

log gamma function

This returns 2 piddles -- the first set gives the log(gamma) values,
while the second set, of integer values, gives the sign of the gamma
function.  This is useful for determining factorials, amongst other
things.




=cut




sub PDL::lgamma {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_lgamma_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_lgamma_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_lgamma_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for lgamma";
		}
		}

*lgamma = \&PDL::lgamma;




=head2 erfi

=for sig

  Signature: (a(); [o]b())

=for ref

The inverse of the error function

=cut




sub PDL::erfi {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_erfi_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_erfi_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_erfi_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for erfi";
		}
		}

*erfi = \&PDL::erfi;




=head2 eigens

=for sig

  Signature: ([phys]a(m); [o,phys]ev(n,n); [o,phys]e(n))


=for ref

Eigenvalues and -vectors of a matrix in lower triangular form

XXX Hard interface

=cut

=cut




sub PDL::eigens {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_eigens_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_eigens_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_eigens_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for eigens";
		}
		}

*eigens = \&PDL::eigens;




=head2 simq

=for sig

  Signature: ([phys]a(n,n); [phys]b(n); [o,phys]x(n); int [o,phys]ips(n); int flag)


=for ref

Solution of simultaneous linear equations. 

(XXX hard interface)



=cut




sub PDL::simq {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_simq_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_simq_int;
		} elsif($#_ == 2) {
			@_ = @_;
			my @ret;
			$_[4] = $_[2];
unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_simq_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for simq";
		}
		}

*simq = \&PDL::simq;




=head2 squaretotri

=for sig

  Signature: (a(n,n); b(m))


=for ref

Convert a symmetric square matrix to triangular vector storage



=cut




sub PDL::squaretotri {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_squaretotri_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_squaretotri_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_squaretotri_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for squaretotri";
		}
		}

*squaretotri = \&PDL::squaretotri;


;
 

=head1 BUGS

Hasn't been tested on all platforms to ensure Cephes
versions are picked up automatically and used correctly.

=head1 AUTHOR

Copyright (C) R.J.R. Williams 1997 (rjrw@ast.leeds.ac.uk), Karl Glazebrook
(kgb@aaoepp.aao.gov.au) and Tuomas J. Lukka (Tuomas.Lukka@helsinki.fi). 

All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL 
distribution. If this file is separated from the PDL distribution, 
the copyright notice should be included in the file.


=cut




# Exit with OK status

1;

