
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Image2D;

@EXPORT_OK  = qw( conv2d med2d patch2d max2d_ind centroid2d cc8compt );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;
@ISA    = qw( PDL::Exporter DynaLoader );

bootstrap PDL::Image2D;


=head1 NAME

PDL::Image2D - Miscellaneous 2D image processing functions


=head1 DESCRIPTION

  Miscellaneous 2D image processing functions - for want
  of anywhere else to put them

=head1 SYNOPSIS

 use PDL::Image2D;

=cut







=head1 FUNCTIONS



=cut






=head2 conv2d

=for sig

  Signature: (a(m,n); kern(p,q); [o]b(m,n); int opt)

=head2 conv2d

=for ref

2D convolution of an array with a kernel (smoothing)

=for usage

 $new = conv2d $old, $kernel, {OPTIONS}

=for example

  perldl> $smoothed = conv2d $image, ones(3,3), {Boundary => Reflect}

=for options

 Boundary - controls what values are assumed for the image when kernel 
            crosses its edge:
 	    => Default  - periodic boundary conditions (i.e. wrap around axis)
 	    => Reflect  - reflect at boundary
 	    => Truncate - truncate at boundary



=cut





        
sub PDL::conv2d {
   my $opt; $opt = pop @_ if ref($_[$#_]) eq 'HASH';
   die 'Usage: conv2d( a(m,n), kern(p,q), [o]b(m,n), {Options} )'
      if $#_<1 || $#_>2;
   my($a,$kern) = @_;
   my $c = $#_ == 2 ? $_[2] : PDL->null;
   &PDL::_conv2d_int($a,$kern,$c, 
	(!(defined $opt && exists $$opt{Boundary}))?0:
	(($$opt{Boundary} eq "Reflect") +
	2*($$opt{Boundary} eq "Truncate")));
   return $c;
}



*conv2d = \&PDL::conv2d;




=head2 med2d

=for sig

  Signature: (a(m,n); kern(p,q); [o]b(m,n); int opt)


=head2 med2d

=for ref 

2D median-convolution of an array with a kernel (smoothing)

Note: only points in the kernel >0 are included in the median, other
points are weighted by the kernel value (medianing lots of zeroes
is rather pointless)

=for usage

 $new = med2d $old, $kernel, {OPTIONS}

=for example

  perldl> $smoothed = med2d $image, ones(3,3), {Boundary => Reflect}

=for options

 Boundary - controls what values are assumed for the image when kernel 
            crosses its edge:
 	    => Default  - periodic boundary conditions (i.e. wrap around axis)
 	    => Reflect  - reflect at boundary
 	    => Truncate - truncate at boundary



=cut





        
sub PDL::med2d {
   my $opt; $opt = pop @_ if ref($_[$#_]) eq 'HASH';
   die 'Usage: med2d( a(m,n), kern(p,q), [o]b(m,n), {Options} )'
      if $#_<1 || $#_>2;
   my($a,$kern) = @_;
   my $c = $#_ == 2 ? $_[2] : PDL->null;
   &PDL::_med2d_int($a,$kern,$c,
	(!(defined $opt && exists $opt->{Boundary}))?0:
	(($$opt{Boundary} eq "Reflect") +
	2*($$opt{Boundary} eq "Truncate")));
   return $c;
}



*med2d = \&PDL::med2d;




=head2 patch2d

=for sig

  Signature: (a(m,n); int bad(m,n); [o]b(m,n))

=head2 patch2d

=for ref

patch bad pixels out of 2D images, 

=for usage

$patched = patch2d $data, $bad;

$bad is a 2D mask array where 1=bad pixel 0=good pixel. Pixels are replaced by the average
of their non-bad neighbours.



=cut




sub PDL::patch2d {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_patch2d_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_patch2d_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_patch2d_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for patch2d";
		}
		}

*patch2d = \&PDL::patch2d;




=head2 max2d_ind

=for sig

  Signature: (a(m,n); [o]b(); int [o]c(); int[o]d())

=head2 max2d_ind

=for ref

Return value/position of maximum value in 2D image

Contributed by Tim Jeness



=cut




sub PDL::max2d_ind {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_max2d_ind_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_max2d_ind_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_max2d_ind_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for max2d_ind";
		}
		}

*max2d_ind = \&PDL::max2d_ind;




=head2 centroid2d

=for sig

  Signature: (im(m,n); x(); y(); box(); [o]xcen(); [o]ycen())

=head2 centroid2d

=for ref

Refine a list of object positions in 2D image by centroiding in a box

$box is the full-width of the box, i.e. the window 
is +/- $box/2



=cut




sub PDL::centroid2d {
		if($#_ == 5 || $#_ == -1 ) { &PDL::_centroid2d_int; }
		 elsif($#_ == 5) { 
		 	@_ = @_;
		 	$_[5] = $_[5];
$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_centroid2d_int;
		} elsif($#_ == 3) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[5] = PDL->null);
unshift @ret,($_[4] = PDL->null);
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_centroid2d_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for centroid2d";
		}
		}

*centroid2d = \&PDL::centroid2d;




=head2 cc8compt

=for sig

  Signature: (a(m,n); [o]b(m,n))


=for ref

Connected 8-component labeling of a binary image.

Connected 8-component labeling of 0,1 image - i.e. find seperate
segmented objects and fill object pixels with object number

=for example

perldl> $segmented = cc8compt($image>$threshold);



=cut




sub PDL::cc8compt {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_cc8compt_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_cc8compt_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_cc8compt_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for cc8compt";
		}
		}

*cc8compt = \&PDL::cc8compt;


;
 

=head1 AUTHORS

Copyright (C) Karl Glazebrook 1997 with additions by Robin Williams
(rjrw@ast.leeds.ac.uk) and Tim Jeness (timj@jach.hawaii.edu). 
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL 
distribution. If this file is separated from the PDL distribution, 
the copyright notice should be included in the file.
 

=cut





# Exit with OK status

1;

