
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Graphics::TriD::Rout;

@EXPORT_OK  = qw( combcoords repulse attract );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;
@ISA    = qw( PDL::Exporter DynaLoader );

bootstrap PDL::Graphics::TriD::Rout;

=head1 NAME

	PDL::Graphics::TriD::Rout - Helper routines for Three-dimensional graphics


=head1 DESCRIPTION

This module is for miscellaneous PP-defined utility routines for
the PDL::Graphics::TriD module. Currently, there are

=head1 AUTHOR

Copyright (C) 1997 Tuomas J. Lukka. 
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL 
distribution. If this file is separated from the PDL distribution, 
the copyright notice should be included in the file.



=cut






=head1 FUNCTIONS



=cut






=head2 combcoords

=for sig

  Signature: (x(); y(); z();
		float [o]coords(tri=3);)

=head2 combcoords

=for ref

Combine three coordinates into a single piddle.

Combine x, y and z to a single piddle the first dimension
of which is 3. This routine does dataflow automatically.



=cut




sub PDL::combcoords {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_combcoords_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_combcoords_int;
		} elsif($#_ == 2) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_combcoords_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for combcoords";
		}
		}

*combcoords = \&PDL::combcoords;




=head2 repulse

=for sig

  Signature: (coords(nc,np);
		 [o]vecs(nc,np);
		 int [t]links(np);; 
		double boxsize;
		int dmult;
		double a;
		double b;
		double c;
		double d;
	)


=for ref

Repulsive potential for molecule-like constructs.

C<repulse> uses a hash table of cubes to quickly calculate
a repulsive force that vanishes at infinity for many
objects. For use by the module PDL::Graphics::TriD::MathGraph.
For definition of the potential, see the actual function.



=cut




sub PDL::repulse {
		if($#_ == 8 || $#_ == -1 ) { &PDL::_repulse_int; }
		 elsif($#_ == 7) { 
		 	@_ = @_;
		 	$_[8] = $_[7];
$_[7] = $_[6];
$_[6] = $_[5];
$_[5] = $_[4];
$_[4] = $_[3];
$_[3] = $_[2];
$_[2] = PDL->null;
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_repulse_int;
		} elsif($#_ == 6) {
			@_ = @_;
			my @ret;
			$_[8] = $_[6];
$_[7] = $_[5];
$_[6] = $_[4];
$_[5] = $_[3];
$_[4] = $_[2];
$_[3] = $_[1];
$_[2] = PDL->null;
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_repulse_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for repulse";
		}
		}

*repulse = \&PDL::repulse;




=head2 attract

=for sig

  Signature: (coords(nc,np);
		int from(nl);
		int to(nl);
		strength(nl);
		[o]vecs(nc,np);; 
		double m;
		double ms;
	)


=for ref

Attractive potential for molecule-like constructs.

C<attract> is used to calculate
an attractive force for many
objects, of which some attract each other (in a way 
like molecular bonds). 
For use by the module PDL::Graphics::TriD::MathGraph.
For definition of the potential, see the actual function.



=cut




sub PDL::attract {
		if($#_ == 6 || $#_ == -1 ) { &PDL::_attract_int; }
		 elsif($#_ == 6) { 
		 	@_ = @_;
		 	$_[6] = $_[6];
$_[5] = $_[5];
$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_attract_int;
		} elsif($#_ == 5) {
			@_ = @_;
			my @ret;
			$_[6] = $_[5];
$_[5] = $_[4];
unshift @ret,($_[4] = PDL->null);
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_attract_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for attract";
		}
		}

*attract = \&PDL::attract;


;
 


# Exit with OK status

1;

