#!/bin/sh

#
# Load the keymaps *as soon as possible*
#

test -f /bin/loadkeys || exit 0

PACKAGE=kbd

CONFDIR=/etc/${PACKAGE}

case $PACKAGE in
kbd) EXT=map ;;
console-tools) EXT=kmap ;;
esac

case "$1" in
    start | restart | force-reload | reload)
	if [ -r ${CONFDIR}/default.${EXT} -o -r ${CONFDIR}/default.${EXT}.gz ] ; then
	    /bin/loadkeys ${CONFDIR}/default.${EXT}
	fi
	;;
    stop)
	;;
    *)
	echo "Usage: $0 {start|stop|restart|reload|force-reload}"
	exit 1
	;;
esac
