/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class LDAPUrl {
    public static String defaultFilter = "(objectClass=*)";
    private String hostName;
    private int portNumber;
    private String DN;
    private Vector attributes;
    private int scope;
    private String filter;
    private String URL;

    public LDAPUrl(String string) throws MalformedURLException {
        Object object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":/?", true);
        String string2 = null;
        this.attributes = null;
        this.scope = 0;
        this.filter = defaultFilter;
        this.URL = string;
        try {
            String string3 = stringTokenizer.nextToken();
            if (!string3.equalsIgnoreCase("LDAP")) {
                throw new MalformedURLException();
            }
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (string3.equals("/")) {
                this.hostName = null;
                this.portNumber = 389;
            } else {
                this.hostName = string3;
                if (stringTokenizer.countTokens() == 0) {
                    this.portNumber = 389;
                    return;
                }
                string3 = stringTokenizer.nextToken();
                if (string3.equals(":")) {
                    this.portNumber = Integer.parseInt(stringTokenizer.nextToken());
                    if (stringTokenizer.countTokens() == 0) {
                        return;
                    }
                    stringTokenizer.nextToken();
                } else {
                    this.portNumber = 389;
                }
            }
            this.DN = LDAPUrl.decode(stringTokenizer.nextToken());
            if (this.DN.equals("?")) {
                this.DN = "";
            }
            if (stringTokenizer.hasMoreTokens()) {
                object = null;
                object = this.readNextConstruct(stringTokenizer);
                if (object != null && this.isAttribute((String)object)) {
                    if (((String)object).equals("?")) {
                        string2 = null;
                        object = stringTokenizer.nextToken();
                    } else {
                        string2 = LDAPUrl.decode((String)object);
                        object = this.readNextConstruct(stringTokenizer);
                    }
                }
                if (object != null && (this.scope = this.getScope((String)object)) != -1) {
                    object = this.readNextConstruct(stringTokenizer);
                } else if (object != null && ((String)object).equals("?")) {
                    this.scope = 0;
                    object = stringTokenizer.nextToken();
                } else {
                    this.scope = 0;
                }
                if (object != null && this.isFilter((String)object)) {
                    this.filter = LDAPUrl.decode((String)object);
                    object = this.readNextConstruct(stringTokenizer);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedURLException();
        }
        if (string2 != null) {
            object = new StringTokenizer(string2, ", ");
            this.attributes = new Vector();
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.attributes.addElement(((StringTokenizer)object).nextToken());
            }
        }
    }

    public LDAPUrl(String string, int n, String string2) {
        this.URL = string != null ? (n != 389 ? "LDAP://" + string + ":" + String.valueOf(n) + "/" + LDAPUrl.encode(string2) : "LDAP://" + string + "/" + LDAPUrl.encode(string2)) : "LDAP:///" + LDAPUrl.encode(string2);
        this.hostName = string;
        this.DN = string2;
        this.portNumber = n;
        this.filter = defaultFilter;
        this.attributes = null;
        this.scope = 0;
    }

    public LDAPUrl(String string, int n, String string2, String[] stringArray, int n2, String string3) {
        if (stringArray != null) {
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            while (n3 < stringArray.length) {
                vector.addElement(stringArray[n3]);
                ++n3;
            }
            this.initialize(string, n, string2, vector.elements(), n2, string3);
            return;
        }
        this.initialize(string, n, string2, null, n2, string3);
    }

    public LDAPUrl(String string, int n, String string2, Enumeration enumeration, int n2, String string3) {
        this.initialize(string, n, string2, enumeration, n2, string3);
    }

    private void initialize(String string, int n, String string2, Enumeration enumeration, int n2, String string3) {
        this.hostName = string;
        this.DN = string2;
        this.portNumber = n;
        this.filter = string3 != null ? string3 : defaultFilter;
        this.scope = n2;
        if (enumeration != null) {
            this.attributes = new Vector();
            while (enumeration.hasMoreElements()) {
                this.attributes.addElement(enumeration.nextElement());
            }
        } else {
            this.attributes = null;
        }
        StringBuffer stringBuffer = new StringBuffer("LDAP://");
        if (string != null) {
            stringBuffer.append(string);
            if (n != 389) {
                stringBuffer.append(':');
                stringBuffer.append(String.valueOf(n));
            }
        }
        stringBuffer.append('/');
        stringBuffer.append(LDAPUrl.encode(string2));
        if (enumeration != null) {
            stringBuffer.append('?');
            Enumeration enumeration2 = this.attributes.elements();
            boolean bl = true;
            while (enumeration2.hasMoreElements()) {
                if (!bl) {
                    stringBuffer.append(',');
                } else {
                    bl = false;
                }
                stringBuffer.append((String)enumeration2.nextElement());
            }
        }
        if (string3 != null) {
            if (enumeration == null) {
                stringBuffer.append('?');
            }
            stringBuffer.append('?');
            switch (n2) {
                default: {
                    stringBuffer.append("base");
                    break;
                }
                case 1: {
                    stringBuffer.append("one");
                    break;
                }
                case 2: {
                    stringBuffer.append("sub");
                }
            }
            stringBuffer.append('?');
            stringBuffer.append(string3);
        }
        this.URL = stringBuffer.toString();
    }

    public String getHost() {
        return this.hostName;
    }

    public int getPort() {
        return this.portNumber;
    }

    public String getDN() {
        return this.DN;
    }

    public Enumeration getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.elements();
    }

    public String[] getAttributeArray() {
        if (this.attributes == null) {
            return null;
        }
        String[] stringArray = new String[this.attributes.size()];
        Enumeration enumeration = this.getAttributes();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public int getScope() {
        return this.scope;
    }

    private int getScope(String string) {
        int n = -1;
        if (string.equalsIgnoreCase("base")) {
            n = 0;
        } else if (string.equalsIgnoreCase("one")) {
            n = 1;
        } else if (string.equalsIgnoreCase("sub")) {
            n = 2;
        }
        return n;
    }

    public String getFilter() {
        return this.filter;
    }

    public String getUrl() {
        return this.URL;
    }

    private boolean isFilter(String string) {
        return string.startsWith("(");
    }

    private boolean isAttribute(String string) {
        return !string.startsWith("(") && !string.equalsIgnoreCase("base") && !string.equalsIgnoreCase("one") && !string.equalsIgnoreCase("sub");
    }

    private String readNextConstruct(StringTokenizer stringTokenizer) throws MalformedURLException {
        try {
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                return stringTokenizer.nextToken();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURLException();
        }
        return null;
    }

    private static int hexValue(char c) throws MalformedURLException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new MalformedURLException();
    }

    private static char hexChar(int n) {
        if (n < 0 || n > 15) {
            return 'x';
        }
        if (n < 10) {
            return (char)(n + 48);
        }
        return (char)(n - 10 + 97);
    }

    public static String decode(String string) throws MalformedURLException {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        try {
            while (n < stringBuffer.length()) {
                if (stringBuffer.charAt(n) != '%') {
                    if (n != n2) {
                        stringBuffer.setCharAt(n2, stringBuffer.charAt(n));
                    }
                    ++n;
                    ++n2;
                    continue;
                }
                stringBuffer.setCharAt(n2, (char)(LDAPUrl.hexValue(stringBuffer.charAt(n + 1)) << 4 | LDAPUrl.hexValue(stringBuffer.charAt(n + 2))));
                ++n2;
                n += 3;
            }
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new MalformedURLException();
        }
        stringBuffer.setLength(n2);
        return stringBuffer.toString();
    }

    public static String encode(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || "$-_.+!*'(),".indexOf(c) > 0) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("%");
                stringBuffer.append(LDAPUrl.hexChar((c & 0xF0) >> 4));
                stringBuffer.append(LDAPUrl.hexChar(c & 0xF));
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

