
#include <ib.h>
#include <ibP.h>

/*
 *-----------------------------------------------------------------
 * Filename:  	FindLstn.c
 * Author:    	Tobias Blomberg
 * Created:   	1998-08-04
 * Description: Find listening devices on the GPIB.
 *
 * $Log$
 *-----------------------------------------------------------------
 * Signatures:
 * Sign Name  	      	  Email
 * TBg	Tobias Blomberg   blomman@ludd.luth.se
 *
 *-----------------------------------------------------------------
 */

/*
 *-----------------------------------------------------------------
 * Function:  FindLstn
 * Purpose:   Find listening deviceson the GPIB.
 * Input:     boardID - The interface board number.
 *    	      padlist - A list of primary addresses that is
 *    	      	      	terminated by "NOADDR".
 *    	      limit   - Total number of entries that can be placed
 *    	      	      	in "resultlist".
 * Output:    None
 * Author:    Tobias Blomberg
 * Created:   1998-08-04
 * Remarks:   This routine uses DVRSP to check for listeners.
 * Bugs:      If the queried device has a pending SRQ, this
 *    	      will be lost. Error messages are generated by
 *    	      
 *-----------------------------------------------------------------
 */
PUBLIC void FindLstn( int boardID, Addr4882_t *padlist, Addr4882_t *resultlist, int limit )
{
  int i, res = 0;
  char spr;
    
  if (boardID < 0) {
    iberr = EDVR;
    ibsta = CMPL | ERR;
    return;
  }
  
  for (i=0; res<limit; i++) {
    ibBoardFunc(boardID, DVRSP, padlist[i], &spr);
    if (!(ibsta & ERR)) {
      resultlist[res++] = padlist[i];
    }
    if (padlist[i] == NOADDR)  {
      break;
    }
  }
  
  ibcnt = res;
  
} /* FindLstn */
