
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Slices;

@EXPORT_OK  = qw( affineinternal identity index index2d flowconvert converttypei clump xchg mv oneslice slice affine diagonalI lags splitdim threadI identvaff unthread );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;
@ISA    = qw( PDL::Exporter DynaLoader );

bootstrap PDL::Slices;


=head1 NAME

PDL::Slices -- Stupid index tricks

=head1 SYNOPSIS

  use PDL;
  $a = ones(3,3);
  $b = $a->slice('-1:0,(1)');
  $c = $a->dummy(2);


=head1 DESCRIPTION

This package provides many of the powerful PerlDL core index
manipulation routines. These routines are usually two-way
so you can get a unit matrix by

	$a = zeroes(1000,1000);
	$a->diagonal(0,1) ++;

which is usually fairly efficient. See L<pdlindexing> and
L<pdltips> for more examples.

These functions are usually two-way:

	$b = $a->slice("1:3");
	$b += 5;   		# $a is changed!

If you want to force a copy and no "flow" backwards, you need

	$b = $a->slice("1:3")->copy;
	$b += 5;		# $a is not changed.

alternatively, you can use

	$b = $a->slice("1:3")->sever;

which doesn't copy the struct but beware that after

	$b = $a->slice("1:3");
	$c = $b->sever;

the variables $b and $c point to the same object but with ->copy
they do not.

The fact that there is this kind of flow makes PDL a very
powerful language in many ways: since you can alter the original
data by altering some easier-to-use representation of it, many things are 
much easier to accomplish, just like making the above unit matrix.

=cut







=head1 FUNCTIONS



=cut






=head2 affineinternal

=for sig

  Signature: (P(); C())

=for ref

internal

=cut







	*affineinternal = \&PDL::affineinternal;
	sub PDL::affineinternal {
		my $foo=PDL->null;
		my $this = shift;
		PDL::affineinternal_XX($this,$foo,@_);
		$foo
	}
	




=head2 identity

=for sig

  Signature: (P(); C())

=for ref

internal

=cut







	*identity = \&PDL::identity;
	sub PDL::identity {
		my $foo=PDL->null;
		my $this = shift;
		PDL::identity_XX($this,$foo,@_);
		$foo
	}
	




=head2 index

=for sig

  Signature: (a(n); int ind(); [oca] c())

=for ref

These functions provide rudimentary index indirection.

=for example

	c = a(ind());
	c = a(ind1(),ind2());

It would be useful to have a more complete function for this
at some point, or at least a perl wrapper, that allows

	$c = $a->islice("1:2",$ind1,"3:4",$ind2");

with many dimensions.  

This function is two-way, i.e. after

        $c = $a->index(pdl[0,5,8]);
        $c .= pdl [0,2,4];

the changes in $c will flow back to $a.



=cut




sub PDL::index {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_index_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_index_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_index_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for index";
		}
		}

*index = \&PDL::index;




=head2 index2d

=for sig

  Signature: (a(na,nb); int inda(); int indb(); [oca] c())

=for ref

These functions provide rudimentary index indirection.

=for example

	c = a(ind());
	c = a(ind1(),ind2());

It would be useful to have a more complete function for this
at some point, or at least a perl wrapper, that allows

	$c = $a->islice("1:2",$ind1,"3:4",$ind2");

with many dimensions.  

This function is two-way, i.e. after

        $c = $a->index(pdl[0,5,8]);
        $c .= pdl [0,2,4];

the changes in $c will flow back to $a.



=cut




sub PDL::index2d {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_index2d_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_index2d_int;
		} elsif($#_ == 2) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_index2d_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for index2d";
		}
		}

*index2d = \&PDL::index2d;




=head2 flowconvert

=for sig

  Signature: (PARENT(); [oca]CHILD(); int totype)

=for ref

internal

=cut




sub PDL::flowconvert {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_flowconvert_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_flowconvert_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			$_[2] = $_[1];
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_flowconvert_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for flowconvert";
		}
		}

*flowconvert = \&PDL::flowconvert;




=head2 converttypei

=for sig

  Signature: (P(); C(); int totype)

=for ref

internal

=cut







	*converttypei = \&PDL::converttypei;
	sub PDL::converttypei {
		my $foo=PDL->null;
		my $this = shift;
		PDL::converttypei_XX($this,$foo,@_);
		$foo
	}
	




=head2 clump

=for sig

  Signature: (P(); C(); int n)


=for ref

"clumps" the first n dimensions into one large dimension

If, for example,  $a has dimensions (5,3,4) then after

=for example

	$b = $a->clump(2);   # Clump 2 first dimensions

the variable $b will have dimensions (15,4) 
and the element $b->at(7,3) refers to the element $a->at(1,2,3).



=cut







	*clump = \&PDL::clump;
	sub PDL::clump {
		my $foo=PDL->null;
		my $this = shift;
		PDL::clump_XX($this,$foo,@_);
		$foo
	}
	




=head2 xchg

=for sig

  Signature: (P(); C(); int n1; int n2)

=for ref

exchange two dimensions

The command 

=for example

	$b = $a->xchg(2,3);

creates $b to be like $a except that the dimensions 2 and 3 
are exchanged with each other i.e.

	$b->at(5,3,2,8) == $a->at(5,3,8,2)



=cut







	*xchg = \&PDL::xchg;
	sub PDL::xchg {
		my $foo=PDL->null;
		my $this = shift;
		PDL::xchg_XX($this,$foo,@_);
		$foo
	}
	




=head2 mv

=for sig

  Signature: (P(); C(); int n1; int n2)

=for ref

move a dimension to another position

The command

=for example

	$b = $a->mv(4,1);

creates $b to be like $a except that the dimension 4 is moved to the
place 1:

	$b->at(1,2,3,4,5,6) == $a->at(1,5,2,3,4,6);

The other dimensions are moved accordingly.



=cut







	*mv = \&PDL::mv;
	sub PDL::mv {
		my $foo=PDL->null;
		my $this = shift;
		PDL::mv_XX($this,$foo,@_);
		$foo
	}
	




=head2 oneslice

=for sig

  Signature: (P(); C(); int nth; int from; int step; int nsteps)

=for ref

experimental function - not for public use

=for example

  $a = oneslice();

This is not for public use currently. See the source if you have to.
This function can be used to accomplish run-time changing of
transformations i.e. changing the size of some piddle at run-time.

However, the mechanism is not yet finalized and this is just a demonstration.



=cut







	*oneslice = \&PDL::oneslice;
	sub PDL::oneslice {
		my $foo=PDL->null;
		my $this = shift;
		PDL::oneslice_XX($this,$foo,@_);
		$foo
	}
	




=head2 slice

=for sig

  Signature: (P(); C(); char* str)

=for ref

Returns a rectangular slice of the original piddle 

=for example

  $a->slice('1:3'); #  return the second to fourth elements of $a

The argument string is a comma-separated list of what to do 
for each dimension. The current formats include 
the following (a,b and c are integers):

=over 8

=item ":"

takes the whole dimension intact.

=item ""

(nothing) is a synonym for ":"
(This means that C<$a-E<gt>slice(':,3')> is equal to $a-E<gt>slice(',3')).

=item "n"

slices only this value out of the corresponding dimension

=item "(n)"

means the same as "n" by itself except that the resulting 
dimension of length one is deleted (so if $a has dims (3,4,5) then
C<$a-E<gt>slice(':,(2),:')> has dimensions (3,5) whereas
$a-E<gt>slice(':,2,:') has dimensions (3,1,5)).

=item "a:b"

slices the range I<a> to I<b> inclusive out of the dimension

=item "a:b:c"

slices the range I<a> to I<b>, with step c (i.e. 3:7:2 gives the indices
(3,5,7)). This may be confusing to Matlab users but several other
packages already use this syntax.

=item "*"

inserts an extra dimension of width 1 and

=item "*a"

inserts an extra (dummy) dimension of width I<a>.

=back

An extension is planned for a later stage allowing
$a->slice('(=1),(=1|5:8),3:6(=1),4:6') to express a multidimensional
diagonal of $a.



=cut







	*slice = \&PDL::slice;
	sub PDL::slice {
		my $foo=PDL->null;
		my $this = shift;
		PDL::slice_XX($this,$foo,@_);
		$foo
	}
	




=head2 affine

=for sig

  Signature: (P(); C(); int offspar; SV *dimlist; SV *inclist)

=for ref

internal

=cut







	*affine = \&PDL::affine;
	sub PDL::affine {
		my $foo=PDL->null;
		my $this = shift;
		PDL::affine_XX($this,$foo,@_);
		$foo
	}
	




=head2 diagonalI

=for sig

  Signature: (P(); C(); SV *list)

=for ref

Returns the multidimensional diagonal over the specified dimensions.

The diagonal is placed at the first (by number) dimension that is 
diagonalized.
The other diagonalized dimensions are removed. So if $a has dimensions 
(5,3,5,4,6,5) then after

=for example

	$b = $a->diagonal(0,2,5);

the piddle $b has dimensions (5,3,4,6) and $b->at(2,1,0,1) refers
to $a->at(2,1,2,0,1,2).

NOTE: diagonal doesn't handle threadids correctly. XXX FIX



=cut







	*diagonalI = \&PDL::diagonalI;
	sub PDL::diagonalI {
		my $foo=PDL->null;
		my $this = shift;
		PDL::diagonalI_XX($this,$foo,@_);
		$foo
	}
	




=head2 lags

=for sig

  Signature: (P(); C(); int nthdim; int step; int n)

=for ref

Returns a piddle of lags to parent.

I.e. if $a contains

       [0,1,2,3,4,5,6,7]

then 

=for example

	$b = $a->lags(0,2,2);

 is a (5,2) matrix

       [2,3,4,5,6,7]
       [0,1,2,3,4,5]

This order of returned indices is kept because the function is
called "lags" i.e. the nth lag is n steps behind the original.



=cut







	*lags = \&PDL::lags;
	sub PDL::lags {
		my $foo=PDL->null;
		my $this = shift;
		PDL::lags_XX($this,$foo,@_);
		$foo
	}
	




=head2 splitdim

=for sig

  Signature: (P(); C(); int nthdim; int nsp)

=for ref

Splits a dimension in the parent piddle (opposite of C<clump>)

After

=for example

	$b = $a->splitdim(2,3);

the expression 

	$b->at(6,4,x,y,3,6) == $a->at(6,4,x+3*y)

is always true (x has to be less than 3).



=cut







	*splitdim = \&PDL::splitdim;
	sub PDL::splitdim {
		my $foo=PDL->null;
		my $this = shift;
		PDL::splitdim_XX($this,$foo,@_);
		$foo
	}
	




=head2 threadI

=for sig

  Signature: (P(); C(); int id; SV *list)

=for ref

internal

Put some dimensions to a threadid.

=for example

	$b = $a->threadI(0,1,5); # thread over dims 1,5 in id 1



=cut







	*threadI = \&PDL::threadI;
	sub PDL::threadI {
		my $foo=PDL->null;
		my $this = shift;
		PDL::threadI_XX($this,$foo,@_);
		$foo
	}
	




=head2 identvaff

=for sig

  Signature: (P(); C())

=for ref

A vaffine identity transformation (includes thread_id copying).

Mainly for internal use.



=cut







	*identvaff = \&PDL::identvaff;
	sub PDL::identvaff {
		my $foo=PDL->null;
		my $this = shift;
		PDL::identvaff_XX($this,$foo,@_);
		$foo
	}
	




=head2 unthread

=for sig

  Signature: (P(); C(); int atind)

=for ref

All threaded dimensions are made real again.

See L<XXX> for details and examples.



=cut







	*unthread = \&PDL::unthread;
	sub PDL::unthread {
		my $foo=PDL->null;
		my $this = shift;
		PDL::unthread_XX($this,$foo,@_);
		$foo
	}
	


;
 

=head1 AUTHOR

Copyright (C) 1997 Tuomas J. Lukka.  
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL 
distribution. If this file is separated from the PDL distribution, 
the copyright notice should be included in the file.


=cut





# Exit with OK status

1;

