
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::Primitive;

@EXPORT_OK  = qw( sumover prodover average medover oddmedover avg sum min max median oddmedian minmax qsort axisvalues inner outer innerwt inner2 inner2d inner2t minimum minimum_ind minimum_n_ind maximum maximum_ind maximum_n_ind minmaximum hclip lclip clip wtstat random randsym grandom assgn vsearch interpol one2nd which which_both where histogram whistogram histogram2d whistogram2d crossp norm stats whichND fibonacci );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;
@ISA    = qw( PDL::Exporter DynaLoader );

bootstrap PDL::Primitive;


use PDL::Slices;
use Carp;

=head1 NAME

PDL::Primitive - primitive operations for pdl

=head1 DESCRIPTION

This module provides some primitive and useful functions defined 
using PDL::PP and able to use the new indexing tricks.

See L<PDL::Indexing> for how to use indices creatively.

For explanation of the signature format, see L<PDL::PP>.

=head1 SYNOPSIS

 use PDL::Primitive;


=cut







=head1 FUNCTIONS



=cut






=head2 sumover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via sum to N-1 dimensions

This functions reduces the dimensionality of a piddle
by one by taking the sum along the 1st dimension.

By using C<xchg> etc. (see L<PDL::Slices>) it is possible to use
I<any> dimension.

=for usage

    $a = sumover($b);

=for example

	$spectrum = sumover $image->xchg(0,1) 

	


=cut




sub PDL::sumover {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_sumover_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_sumover_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_sumover_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for sumover";
		}
		}

*sumover = \&PDL::sumover;




=head2 prodover

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via product to N-1 dimensions

This functions reduces the dimensionality of a piddle
by one by taking the product along the 1st dimension.

By using C<xchg> etc. (see L<PDL::Slices>) it is possible to use
I<any> dimension.

=for usage

    $a = prodover($b);

=for example

	$spectrum = prodover $image->xchg(0,1) 

	


=cut




sub PDL::prodover {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_prodover_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_prodover_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_prodover_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for prodover";
		}
		}

*prodover = \&PDL::prodover;




=head2 average

=for sig

  Signature: (a(n); int+ [o]b())


=for ref

Project via average to N-1 dimensions

This functions reduces the dimensionality of a piddle
by one by taking the average along the 1st dimension.

By using C<xchg> etc. (see L<PDL::Slices>) it is possible to use
I<any> dimension.

=for usage

    $a = average($b);

=for example

	$spectrum = average $image->xchg(0,1) 

	


=cut




sub PDL::average {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_average_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_average_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_average_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for average";
		}
		}

*average = \&PDL::average;




=head2 medover

=for sig

  Signature: (a(n); [o]b(); [t]tmp(n))


=for ref

Project via median to N-1 dimensions

This functions reduces the dimensionality of a piddle
by one by taking the median along the 1st dimension.

By using C<xchg> etc. (see L<PDL::Slices>) it is possible to use
I<any> dimension.

=for usage

    $a = medover($b);

=for example

	$spectrum = medover $image->xchg(0,1) 

	


=cut




sub PDL::medover {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_medover_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[2] = PDL->null;
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_medover_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			$_[2] = PDL->null;
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_medover_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for medover";
		}
		}

*medover = \&PDL::medover;




=head2 oddmedover

=for sig

  Signature: (a(n); [o]b(); [t]tmp(n))


=for ref

Project via oddmedian to N-1 dimensions

This functions reduces the dimensionality of a piddle
by one by taking the oddmedian along the 1st dimension.

By using C<xchg> etc. (see L<PDL::Slices>) it is possible to use
I<any> dimension.

=for usage

    $a = oddmedover($b);

=for example

	$spectrum = oddmedover $image->xchg(0,1) 



The median is sometimes not a good choice as if the array has
an even number of elements it lies half-way between the two
middle values - thus it does not always correspond to a data
value. The lower-odd median is just the lower of these two values
and so it ALWAYS sits on an actual data value which is useful in
some circumstances.
		


=cut




sub PDL::oddmedover {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_oddmedover_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[2] = PDL->null;
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_oddmedover_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			$_[2] = PDL->null;
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_oddmedover_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for oddmedover";
		}
		}

*oddmedover = \&PDL::oddmedover;



=head2 avg

=for ref

Return the average of all elements in a piddle

=for usage

$x = avg($data);

=cut

*avg = \&PDL::avg;
sub PDL::avg {
	my($x) = @_; my $tmp;
	average($x->clump(-1),($tmp=null));
	return $tmp->at();
}



=head2 sum

=for ref

Return the sum of all elements in a piddle

=for usage

$x = sum($data);

=cut

*sum = \&PDL::sum;
sub PDL::sum {
	my($x) = @_; my $tmp;
	sumover($x->clump(-1),($tmp=null));
	return $tmp->at();
}



=head2 min

=for ref

Return the minimum of all elements in a piddle

=for usage

$x = min($data);

=cut

*min = \&PDL::min;
sub PDL::min {
	my($x) = @_; my $tmp;
	minimum($x->clump(-1),($tmp=null));
	return $tmp->at();
}



=head2 max

=for ref

Return the maximum of all elements in a piddle

=for usage

$x = max($data);

=cut

*max = \&PDL::max;
sub PDL::max {
	my($x) = @_; my $tmp;
	maximum($x->clump(-1),($tmp=null));
	return $tmp->at();
}



=head2 median

=for ref

Return the median of all elements in a piddle

=for usage

$x = median($data);

=cut

*median = \&PDL::median;
sub PDL::median {
	my($x) = @_; my $tmp;
	medover($x->clump(-1),($tmp=null));
	return $tmp->at();
}



=head2 oddmedian

=for ref

Return the oddmedian of all elements in a piddle

=for usage

$x = oddmedian($data);

=cut

*oddmedian = \&PDL::oddmedian;
sub PDL::oddmedian {
	my($x) = @_; my $tmp;
	oddmedover($x->clump(-1),($tmp=null));
	return $tmp->at();
}



=head2 minmax

=for ref

Returns piddle with minimum, maximum of a piddle.

=for usage

 ($mn, $mx) = minmax($pdl);

 Return $mn as minimum, $mx as maximum, $mn_ind as the index of minimum and 
 $mx_ind as the index of the maximum.

=for example

 perldl> $x = pdl [1,-2,3,5,0]

 perldl> ($min, $max) = minmax($x);

 perldl> p "$min $max\n";


=cut

*minmax = \&PDL::minmax;
sub PDL::minmax {
  my ($x)=@_; my $tmp;
  return minmaximum($x->clump(-1));
}





=head2 qsort

=for sig

  Signature: (a(n); [o]b(n))


=for ref

Quicksort a vector into ascending order.

XXX Todo: qsortind



=cut




sub PDL::qsort {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_qsort_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_qsort_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_qsort_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for qsort";
		}
		}

*qsort = \&PDL::qsort;




=head2 axisvalues

=for sig

  Signature: ([o,nc]a(n))


=for ref 

Internal routine

C<axisvalues> is the internal primitive that implements C<axisvals> and
alters its argument.



=cut




sub PDL::axisvalues {
		if($#_ == 0 || $#_ == -1 ) { &PDL::_axisvalues_int; }
		 elsif($#_ == 0) { 
		 	@_ = @_;
		 	$_[0] = $_[0];

			&PDL::_axisvalues_int;
		} elsif($#_ == -1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[0] = PDL->null);

			&PDL::_axisvalues_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for axisvalues";
		}
		}

*axisvalues = \&PDL::axisvalues;




=head2 inner

=for sig

  Signature: (a(n); b(n); [o]c(); )


=for ref

Inner product over one dimension

	c = sum_i a_i * b_i



=cut




sub PDL::inner {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_inner_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for inner";
		}
		}

*inner = \&PDL::inner;




=head2 outer

=for sig

  Signature: (a(n); b(m); [o]c(n,m); )

=for ref

outer product over one dimension

Naturally, it is possiblet to achieve the effects of outer 
product simply by threading over the "C<*>"
operator but this function is provided for convenience.



=cut




sub PDL::outer {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_outer_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_outer_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_outer_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for outer";
		}
		}

*outer = \&PDL::outer;


=head2 matmult

=for sig

 Signature: matmult(a(x,y),b(y,z),[o]c(x,z))

=for ref

Matrix multiplication 

We peruse the inner product to define matrix multiplication
via a threaded inner product

=cut

  sub matmult {
    my ($a,$b,$c) = @_;
    if(!defined $c) {$c = PDL->null}
    inner($a->dummy(1),$b->xchg(0,1)->dummy(2),$c);
    return $c;
  }




=head2 innerwt

=for sig

  Signature: (a(n); b(n); c(n); [o]d(); )


=for ref

Weighted (i.e. triple) inner product

	d = sum_i a(i) b(i) c(i)


=cut




sub PDL::innerwt {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_innerwt_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_innerwt_int;
		} elsif($#_ == 2) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_innerwt_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for innerwt";
		}
		}

*innerwt = \&PDL::innerwt;




=head2 inner2

=for sig

  Signature: (a(n); b(n,m); c(m); [o]d())


=for ref

Inner product of two vectors and a matrix

	d = sum_ij a(i) b(i,j) c(j)

Note that you should probably not thread over a and c since that would be  very
wasteful. Instead, you should use a temporary for b*c.



=cut




sub PDL::inner2 {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_inner2_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner2_int;
		} elsif($#_ == 2) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner2_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for inner2";
		}
		}

*inner2 = \&PDL::inner2;




=head2 inner2d

=for sig

  Signature: (a(n,m); b(n,m); [o]c())


=for ref

Inner product over 2 dimensions.

Equivalent to

	$c = inner($a->clump(2), $b->clump(2))



=cut




sub PDL::inner2d {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_inner2d_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner2d_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner2d_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for inner2d";
		}
		}

*inner2d = \&PDL::inner2d;




=head2 inner2t

=for sig

  Signature: (a(j,n); b(n,m); c(m,k); [t]tmp(n,k); [o]d(j,k)))

=for ref

Efficient Triple matrix product a*b*c 

Efficiency comes from by using the temporary tmp. This operation only scales as
N**3 whereas threading using inner2 would scale as N**4.

The reason for having this routine is that you do not need to
have the same thread-dimensions for C<tmp> as for the other arguments,
which in case of large numbers of matrices makes this much more
memory-efficient.

It is hoped that things like this could be taken care of as a kind of
closures at some point.



=cut




sub PDL::inner2t {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_inner2t_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[4] = $_[3];
$_[3] = PDL->null;
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner2t_int;
		} elsif($#_ == 2) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[4] = PDL->null);
$_[3] = PDL->null;
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_inner2t_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for inner2t";
		}
		}

*inner2t = \&PDL::inner2t;




=head2 minimum

=for sig

  Signature: (a(n); [o]c())


=for ref

Project via minimum to N-1 dimensions

This functions reduces the dimensionality of a piddle
by one by taking the minimum along the 1st dimension.

By using C<xchg> etc. (see L<PDL::Slices>) it is possible to use
I<any> dimension.

=for usage

    $a = minimum($b);

=for example

	$spectrum = minimum $image->xchg(0,1) 

	


=cut




sub PDL::minimum {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_minimum_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_minimum_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_minimum_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for minimum";
		}
		}

*minimum = \&PDL::minimum;




=head2 minimum_ind

=for sig

  Signature: (a(n); int[o]c())

=for ref

Like minimum but returns the index rather than the value

=cut




sub PDL::minimum_ind {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_minimum_ind_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_minimum_ind_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_minimum_ind_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for minimum_ind";
		}
		}

*minimum_ind = \&PDL::minimum_ind;




=head2 minimum_n_ind

=for sig

  Signature: (a(n); int[o]c(m))

=for ref

Returns the index of C<m> minimum elements

=cut




sub PDL::minimum_n_ind {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_minimum_n_ind_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_minimum_n_ind_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_minimum_n_ind_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for minimum_n_ind";
		}
		}

*minimum_n_ind = \&PDL::minimum_n_ind;




=head2 maximum

=for sig

  Signature: (a(n); [o]c())


=for ref

Project via maximum to N-1 dimensions

This functions reduces the dimensionality of a piddle
by one by taking the maximum along the 1st dimension.

By using C<xchg> etc. (see L<PDL::Slices>) it is possible to use
I<any> dimension.

=for usage

    $a = maximum($b);

=for example

	$spectrum = maximum $image->xchg(0,1) 

	


=cut




sub PDL::maximum {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_maximum_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_maximum_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_maximum_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for maximum";
		}
		}

*maximum = \&PDL::maximum;




=head2 maximum_ind

=for sig

  Signature: (a(n); int[o]c())

=for ref

Like maximum but returns the index rather than the value

=cut




sub PDL::maximum_ind {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_maximum_ind_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_maximum_ind_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_maximum_ind_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for maximum_ind";
		}
		}

*maximum_ind = \&PDL::maximum_ind;




=head2 maximum_n_ind

=for sig

  Signature: (a(n); int[o]c(m))

=for ref

Returns the index of C<m> maximum elements

=cut




sub PDL::maximum_n_ind {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_maximum_n_ind_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_maximum_n_ind_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_maximum_n_ind_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for maximum_n_ind";
		}
		}

*maximum_n_ind = \&PDL::maximum_n_ind;



=cut
=head2 minmaximum

=for ref

 Find minimum and maximum and their indices for a given piddle;

=for usage
   
        perldl> $a=pdl [[-2,3,4],[1,0,3]]

	perldl> ($min, $max, $min_ind, $max_ind)=minmaximum($a)
 
        perldl> p $min, $max, $min_ind, $max_ind
        [-2 0] [4 3] [0 1] [2 2]

        See also minmax, which clumps the piddle together.

=cut




=head2 minmaximum

=for sig

  Signature: (a(n); [o]cmin(); [o] cmax(); int [o]cmin_ind(); int [o]cmax_ind())


=for ref

info not available


=cut




sub PDL::minmaximum {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_minmaximum_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_minmaximum_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[4] = PDL->null);
unshift @ret,($_[3] = PDL->null);
unshift @ret,($_[2] = PDL->null);
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_minmaximum_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for minmaximum";
		}
		}

*minmaximum = \&PDL::minmaximum;




=head2 hclip

=for sig

  Signature: (a(); b(); [o] c())

=for ref

clip $a by $b ($b is upper bound)

=cut




sub PDL::hclip {
   my ($a,$b) = @_;
   my $c;
   if ($a->is_inplace) {
       $a->set_inplace(0); $c = $a;
   } elsif ($#_ > 1) {$c=$_[2]} else {$c=PDL->null}
   &PDL::_hclip_int($a,$b,$c);
   return $c;
}


*hclip = \&PDL::hclip;




=head2 lclip

=for sig

  Signature: (a(); b(); [o] c())

=for ref

clip $a by $b ($b is lower bound)

=cut




sub PDL::lclip {
   my ($a,$b) = @_;
   my $c;
   if ($a->is_inplace) {
       $a->set_inplace(0); $c = $a;
   } elsif ($#_ > 1) {$c=$_[2]} else {$c=PDL->null}
   &PDL::_lclip_int($a,$b,$c);
   return $c;
}


*lclip = \&PDL::lclip;



=head2 clip

=for ref

Clip a piddle by (optional) upper or lower bounds.

=for usage

	$b = $a->clip(0,3); 
	$c = $a->clip(undef, $x);

=cut

*clip = \&PDL::clip;
sub PDL::clip {
  my($a, $b, $c) = @_;
  my $d; if($a->is_inplace) {$a->set_inplace(0); $d = $a} 
  elsif($#_ > 2) {$d=$_[3]} else {$d = PDL->null}
  if(defined $b) {
  	&PDL::_lclip_int($a,$b,$d);
	if(defined $c) {
		&PDL::_hclip_int($d,$c,$d);
	}
  } elsif(defined $c) {
	&PDL::_hclip_int($a,$c,$d);
  }
  return $d;
}





=head2 wtstat

=for sig

  Signature: (a(n); wt(n); avg(); [o]b(); int deg)

=head2 wtstat

=for ref

Weighted statistical moment of given degree

This calculates a weighted statistic over the vector a. 
The formula is  

 b() = (sum_i wt_i * (a_i ** degree - avg)) / (sum_i wt_i)



=cut




sub PDL::wtstat {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_wtstat_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_wtstat_int;
		} elsif($#_ == 3) {
			@_ = @_;
			my @ret;
			$_[4] = $_[3];
unshift @ret,($_[3] = PDL->null);
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_wtstat_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for wtstat";
		}
		}

*wtstat = \&PDL::wtstat;



=head2 random

=for ref

Constructor which returns piddle of random numbers

=for usage

   $a = random([type], $nx, $ny, $nz,...);
   $a = random $b;
   
   etc. (see 'zeroes')

This is the uniform distribution between 0 and 1 (assumedly
excluding 1 itself). The arguments are the same as C<zeroes>
(q.v.) - i.e. one can specify dimensions, types or give
a template.

=head2 randsym

=for ref

Constructor which returns piddle of random numbers

=for usage

   $a = randsym([type], $nx, $ny, $nz,...);
   $a = randsym $b;
   
   etc. (see 'zeroes')

This is the uniform distribution between 0 and 1 (excluding both 0 and
1, cf C<random>). The arguments are the same as C<zeroes> (q.v.) -
i.e. one can specify dimensions, types or give a template.

=cut


sub random { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->random : PDL->random(@_) }
sub PDL::random {
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   &PDL::_random_int($x);
   return $x;
}





sub randsym { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->randsym : PDL->randsym(@_) }
sub PDL::randsym {
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   &PDL::_randsym_int($x);
   return $x;
}






=head2 grandom

=for ref

Constructor which returns piddle of Gaussian random numbers

=for usage

   $a = grandom([type], $nx, $ny, $nz,...);
   $a = grandom $b;

   etc. See 'zeroes'
   
This is generated by summing 12 uniform random
distributions for now. Hopefully someone can be
inspired to create a better version!

Mean = 0, Stddev = 1

=cut

sub grandom { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->grandom : PDL->grandom(@_) }
sub PDL::grandom {
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   use PDL::Math 'erfi';
   $x .= erfi(randsym($x));
   return $x;
}





=head2 assgn

=for sig

  Signature: (a(); [o]b())

=for ref

Plain numerical assignment. This is used to implement the ".=" operator

=cut




sub PDL::assgn {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_assgn_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_assgn_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_assgn_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for assgn";
		}
		}

*assgn = \&PDL::assgn;




=head2 vsearch

=for sig

  Signature: (i(); x(n); int [o]ip())


=for ref

routine for searching 1D values i.e. step-function interpolation.

=for usage

   $inds = vsearch($vals, $xs);

Returns for each value of $val the index of the least larger member
of $xs (which need to be in increasing order). If the value is larger
than any member of $xs, the index to the last element of $xs is returned.

=for example

This function is useful e.g. when you have a list of probabilities
for events and want to generate indices to events:

	$a = pdl(.01,.86,.93,1); # Barnsley IFS probabilities cumulatively
	$b = random 20;
	$c = vsearch($b, $a); # Now, $c will have the appropriate distr.



=cut




sub PDL::vsearch {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_vsearch_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_vsearch_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_vsearch_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for vsearch";
		}
		}

*vsearch = \&PDL::vsearch;




=head2 interpol

=for sig

  Signature: (i(); x(n); y(n); [o] ip())


=for ref

routine for 1D linear interpolation

=for usage

 $interpolated_values = interpol($interpol_at, $ordered_abscissas, $yvalues)

'interpol' uses a binary search to find the suspects, er...,
interpolation indices and therefore abscissas have to be strictly
ordered (increasing or decreasing). For interpolation at lots of
closely spaced abscissas an approach that uses the last index found as
a start for the next search can be faster (compare Numerical Recipes
'hunt' routine). Feel free to implement that on top of the binary
search if you like. For out of bounds values it just does a linear
extrapolation and issues a warning upon completion.



=cut




sub PDL::interpol {
		if($#_ == 3 || $#_ == -1 ) { &PDL::_interpol_int; }
		 elsif($#_ == 3) { 
		 	@_ = @_;
		 	$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_interpol_int;
		} elsif($#_ == 2) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[3] = PDL->null);
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_interpol_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for interpol";
		}
		}

*interpol = \&PDL::interpol;



=head2 one2nd

=for ref

Converts a one dimensional index piddle to a set of ND coordinates

=for usage

  @coords=one2nd($a, $indices)

returns an array of piddles containing the ND indexes corresponding to 
the one dimensional list indices. The indices are assumed to correspond
to array $a clumped using clump(-1). This routine is used in whichND, 
but is useful on its own occasionally.

=for example
 
 perldl> $a=pdl [[[1,2],[-1,1]], [[0,-3],[3,2]]]; $c=$a->clump(-1)
  
 perldl> $maxind=maximum_ind($c); p $maxind;
 6
 perldl> print one2nd($a, maximum_ind($c))
 0 1 1
 perldl> p $a->at(0,1,1)
 3

=cut


*one2nd = \&PDL::one2nd;
sub PDL::one2nd {
  barf "Usage: one2nd $array $indices\n" if $#_ != 1;
  my ($a, $ind)=@_;
  my @dimension=$a->dims;
  my(@index);
  my $count=0;
  foreach (@dimension) {
    $index[$count++]=$ind % $_;
    $ind=long($ind/$_);
  }
  return @index;
}




=head2 which

=for ref

Returns piddle of indices of non-zero values.

=for usage

 $i = which($mask);

returns a pdl with indices for all those elements that are
nonzero in the mask. Note that mask really has to be 1-D (use clump(-1) 
if you need to work with ND-images) 

If you want to return both the indices of non-zero values and the 
complement, use the function which_both.


=for example

 perldl> $x = sequence(10); p $x
 [0 1 2 3 4 5 6 7 8 9]
 perldl> $indx = which($x>6); p $indx
 [7 8 9]

=cut

=head2 which_both

=for ref

Returns piddle of indices of non-zero values and their complement

=for usage

 ($i, $c_i) = which_both($mask);

This works just as which, but the complement of $i will be in $c_i.

=for example

 perldl> $x = sequence(10); p $x
 [0 1 2 3 4 5 6 7 8 9]
 perldl> ($small, $big) = which_both ($x >= 5); p "$small\n $big"
 [5 6 7 8 9]
 [0 1 2 3 4]

=cut

  




=head2 which

=for sig

  Signature: (mask(n); int [o] inds(m))


=for ref

info not available


=cut




sub PDL::which {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_which_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_which_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_which_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for which";
		}
		}

*which = \&PDL::which;




=head2 which_both

=for sig

  Signature: (mask(n); int [o] inds(m); int [o]notinds(q))


=for ref

info not available


=cut




sub PDL::which_both {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_which_both_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_which_both_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_which_both_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for which_both";
		}
		}

*which_both = \&PDL::which_both;


=head2 where

=for ref

Returns indices to non-zero values or those values from another piddle.

=for usage

 $i = $x->where($x+5 > 0); # $i contains elements of $x
                           # where mask ($x+5 > 0) is 1
 
Note: $i is always 1-D, even if $x is >1-D. The first argument
(the values) and the second argument (the mask) currently have to have
the same initial dimensions (or horrible things happen).

It is also possible to use the same mask for several piddles with
the same call:

 ($i,$j,$k) = where($x,$y,$z, $x+5>0);

There is also the following syntax, retained only for compatibility 
with PDL versions <1.99. 
This use is deprecated, and will be removed
in the future.  Use C<which> instead.
 
 $i = where($x > 0);       # indices to $x, equivalent to 'which()'

Note: the mask has to be 1-D. See the documentation for C<which>

=cut

sub PDL::where {
	if($#_ == 0) {
	        warn "WARNING: one argument form of where() is now deprecated - use which()\n";
		return $_[0]->which();
	} elsif($#_ == 1) {
	        my($data,$mask) = @_;
		$data = $_[0]->clump(-1) if $_[0]->getndims>1;
		$mask = $_[1]->clump(-1) if $_[0]->getndims>1;
		return $data->index($mask->which());
	} else {
		if($_[-1]->getndims > 1) {
			my $mask = $_[-1]->clump(-1)->which;
			return map {$_->clump(-1)->index($mask)} 
				@$_[0..$#$_-1];
		} else {
			my $mask = $_[-1]->which;
			return map {$_->index($mask)} @$_[0..$#$_-1];
		}
	}
}
*where = \&PDL::where;





=head2 histogram

=for sig

  Signature: (in(n); int+[o] hist(m); double step; double min; int msize => m)


=for ref

Calculates a histogram for given stepsize and minimum.

The output is reset in a different threadloop so that you 
can take a histogram of $a(10,12) into $b(15) and get the result
you want.

XXX: needs some more explanation (relation to C<hist()>)
etc. and examples!!!



=cut




sub PDL::histogram {
		if($#_ == 4 || $#_ == -1 ) { &PDL::_histogram_int; }
		 elsif($#_ == 4) { 
		 	@_ = @_;
		 	$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_histogram_int;
		} elsif($#_ == 3) {
			@_ = @_;
			my @ret;
			$_[4] = $_[3];
$_[3] = $_[2];
$_[2] = $_[1];
unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_histogram_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for histogram";
		}
		}

*histogram = \&PDL::histogram;




=head2 whistogram

=for sig

  Signature: (in(n); float+ wt();float+[o] hist(m); double step; double min; int msize => m)


=for ref

Calculates a histogram for given stepsize and minimum.

The output is reset in a different threadloop so that you 
can take a histogram of $a(10,12) into $b(15) and get the result
you want.

XXX: needs some more explanation (relation to C<hist()>)
etc. and examples!!!



=cut




sub PDL::whistogram {
		if($#_ == 5 || $#_ == -1 ) { &PDL::_whistogram_int; }
		 elsif($#_ == 5) { 
		 	@_ = @_;
		 	$_[5] = $_[5];
$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_whistogram_int;
		} elsif($#_ == 4) {
			@_ = @_;
			my @ret;
			$_[5] = $_[4];
$_[4] = $_[3];
$_[3] = $_[2];
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_whistogram_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for whistogram";
		}
		}

*whistogram = \&PDL::whistogram;




=head2 histogram2d

=for sig

  Signature: (ina(n); inb(n); int+[o] hist(ma,mb); double stepa; double mina; int masize => ma;
	              double stepb; double minb; int mbsize => mb;)


=for ref

Calculates a 2d histogram.

XXX: needs some more explanation (relation to C<hist()>)
etc. and examples!!!



=cut




sub PDL::histogram2d {
		if($#_ == 8 || $#_ == -1 ) { &PDL::_histogram2d_int; }
		 elsif($#_ == 8) { 
		 	@_ = @_;
		 	$_[8] = $_[8];
$_[7] = $_[7];
$_[6] = $_[6];
$_[5] = $_[5];
$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_histogram2d_int;
		} elsif($#_ == 7) {
			@_ = @_;
			my @ret;
			$_[8] = $_[7];
$_[7] = $_[6];
$_[6] = $_[5];
$_[5] = $_[4];
$_[4] = $_[3];
$_[3] = $_[2];
unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_histogram2d_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for histogram2d";
		}
		}

*histogram2d = \&PDL::histogram2d;




=head2 whistogram2d

=for sig

  Signature: (ina(n); inb(n); float+ wt();float+[o] hist(ma,mb); double stepa; double mina; int masize => ma;
	              double stepb; double minb; int mbsize => mb;)


=for ref

Calculates a 2d histogram.

XXX: needs some more explanation (relation to C<hist()>)
etc. and examples!!!



=cut




sub PDL::whistogram2d {
		if($#_ == 9 || $#_ == -1 ) { &PDL::_whistogram2d_int; }
		 elsif($#_ == 9) { 
		 	@_ = @_;
		 	$_[9] = $_[9];
$_[8] = $_[8];
$_[7] = $_[7];
$_[6] = $_[6];
$_[5] = $_[5];
$_[4] = $_[4];
$_[3] = $_[3];
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_whistogram2d_int;
		} elsif($#_ == 8) {
			@_ = @_;
			my @ret;
			$_[9] = $_[8];
$_[8] = $_[7];
$_[7] = $_[6];
$_[6] = $_[5];
$_[5] = $_[4];
$_[4] = $_[3];
unshift @ret,($_[3] = PDL->null);
$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_whistogram2d_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for whistogram2d";
		}
		}

*whistogram2d = \&PDL::whistogram2d;




=head2 crossp

=for sig

  Signature: (a(tri=3); b(tri); [o] c(tri))

=for ref

Cross product of two 3D vectors

After

=for example

   $c = crossp $a, $b

the inner product $c*$a and $c*$b will be zero, i.e. $c is
orthogonal to $a and $b



=cut




sub PDL::crossp {
		if($#_ == 2 || $#_ == -1 ) { &PDL::_crossp_int; }
		 elsif($#_ == 2) { 
		 	@_ = @_;
		 	$_[2] = $_[2];
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_crossp_int;
		} elsif($#_ == 1) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[2] = PDL->null);
$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_crossp_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for crossp";
		}
		}

*crossp = \&PDL::crossp;




=head2 norm

=for sig

  Signature: (vec(n); [o] norm(n))

=for ref

Normalises a vector to unit Euclidean length

=cut




sub PDL::norm {
		if($#_ == 1 || $#_ == -1 ) { &PDL::_norm_int; }
		 elsif($#_ == 1) { 
		 	@_ = @_;
		 	$_[1] = $_[1];
$_[0] = $_[0];

			&PDL::_norm_int;
		} elsif($#_ == 0) {
			@_ = @_;
			my @ret;
			unshift @ret,($_[1] = PDL->null);
$_[0] = $_[0];

			&PDL::_norm_int;
			return wantarray?(@ret):$ret[0];
		} else {
			barf "Invalid number of arguments for norm";
		}
		}

*norm = \&PDL::norm;



=head2 stats

=for ref

Calculates useful statistics on a piddle

=for usage

 ($mean,$rms,$median,$min,$max) = stats($piddle,[$weights]); 

This utility calculates all the most useful
quantities in one call.

=cut


*stats	  = \&PDL::stats;
sub PDL::stats {
    barf('Usage: ($mean,[$rms]) = stats($data,[$weights])') if $#_>1;
    my ($data,$weights) = @_;
    my ($mean,$rms);
    if ($#_==0) {
       $mean = sum($data)/($data->nelem);
       $rms = sqrt( sum( ($data-$mean)**2 )/($data->nelem) );
    }
    else {
       $mean = sum($weights*$data)/sum($weights);
       $rms = sqrt( sum( $weights*(($data-$mean)**2) )/sum($weights) );
    }
    my ($median,$min,$max) = ($data->median,$data->min,$data->max);
    print "Mean = $mean, RMS = $rms, Median = $median\n".
          "Min  = $min, Max = $max\n" if $PDL::verbose;
    return $mean unless wantarray;
    return ($mean,$rms,$median,$min,$max);
}


=head2 whichND

=for ref

Returns the coordinates for non-zero values

=for usage

   @coords=whichND($mask);

returns an array of piddles containing the coordinates of the elements
that are non-zero in $mask.

=for example

   perldl> $a=sequence(10,10,3,4)
   
   perldl> ($x, $y, $z, $w)=whichND($a == 203); p $x, $y, $z, $w)
   [3] [0] [2] [0]
   perldl> print $a->at($x,$y,$z,$w)
   203
=cut

*whichND = \&PDL::whichND;
sub PDL::whichND {
  my $mask = shift;
  my $ind=which($mask->clump(-1));

  return one2nd($mask, $ind);
  
}





=head2 fibonacci

=for sig

  Signature: ([o]x(n))

=for ref

Constructor - a vector with Fibonacci's sequence

=cut




sub fibonacci { ref($_[0]) && ref($_[0]) ne 'PDL::Type' ? $_[0]->fibonacci : PDL->fibonacci(@_) }
sub PDL::fibonacci{
   my $class = shift;
   my $x = scalar(@_)? $class->new_from_specification(@_) : $class->new_or_inplace;
   &PDL::_fibonacci_int($x->clump(-1));
   return $x;
}





;
 

=head1 AUTHOR

Copyright (C) Tuomas J. Lukka 1997 (lukka@husc.harvard.edu). Contributions
by Christian Soeller (csoelle@sghms.ac.uk) and Karl Glazebrook
(kgb@aaoepp.aao.gov.au). 
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL 
distribution. If this file is separated from the PDL distribution, 
the copyright notice should be included in the file.


=cut





# Exit with OK status

1;

