
# 
# GENERATED WITH PDL::PP! Don't modify!
#
package PDL::ImageND;

@EXPORT_OK  = qw( convolve );
%EXPORT_TAGS = (Func=>[@EXPORT_OK]);

use PDL::Core;
use PDL::Exporter;
use DynaLoader;
@ISA    = qw( PDL::Exporter DynaLoader );

bootstrap PDL::ImageND;


=head1 NAME

PDL::ImageND - useful image processing routines which work in N-dimensions

=head1 DESCRIPTION

In some cases (though not as many as one would like) it
is possible to write general routines that operate on
N-dimensional objects.

An example in this module is a N-Dim convolution algorithm
I made up one day - it works but the boundary condtions 
are a bit funny.

=head1 SYNOPSIS

 use PDL::ImageND;

=cut







=head1 FUNCTIONS



=cut





use Carp;





=head2 convolve

=for sig

  Signature: (a(m); b(n); int adims(p); int bdims(q); [o]c(m))

=head2 convolve

=for ref

N-dimensional convolution algorithm.

=for usage

$new = convolve $a, $kernel

Convolve an array with a kernel, both of
which are N-dimensional.

Note because of the algorithm used (writing N-dim routines is not easy on the
brain!) the boundary conditions are a bit strange. They wrap, but up to the
NEXT row/column/cube-slice/etc. If this is a problem consider using
zero-padding or something.



=cut




   
        
# Custom Perl wrapper

sub PDL::convolve{
    my($a,$b,$c) = @_;
    barf("Usage: convolve(a(*), b(*), [o]c(*)") if $#_<1 || $#_>2;
    $c = PDL->null if $#_<2;
    &PDL::_convolve_int( $a->clump(-1), $b->clump(-1),
       long([$a->dims]), long([$b->dims]),
       ($c->getndims>1? $c->clump(-1) : $c)
     );
     $c->setdims([$a->dims]);
     return $c;
}       
     


*convolve = \&PDL::convolve;


;
 


=head1 AUTHORS

Copyright (C) Karl Glazebrook 1997. 
All rights reserved. There is no warranty. You are allowed
to redistribute this software / documentation under certain
conditions. For details, see the file COPYING in the PDL 
distribution. If this file is separated from the PDL distribution, 
the copyright notice should be included in the file.


=cut





# Exit with OK status

1;

