/*
 * pf.c			- Print file attributes on an ext2 file system
 *
 * Copyright (C) 1993, 1994  Remy Card <card@masi.ibp.fr>
 *                           Laboratoire MASI, Institut Blaise Pascal
 *                           Universite Pierre et Marie Curie (Paris VI)
 *
 * This file can be redistributed under the terms of the GNU Library General
 * Public License
 */

/*
 * History:
 * 93/10/30	- Creation
 * 96/09/29	- Rewrite to accommodate e2compr (and neaten long format).
 */

/* Fixme: I believe we should get rid of the #ifdef's, and instead make sure that the
   relavent constants are defined.  After all, the behaviour should depend not
   on whatever system include files were active at compilation time, but on
   the kernel under which we're running and which has written to and is
   reading from the filesystem.

   I think it is better to assume that the meaning of the flags field is
   universal across ext2 filesystems than to assume that the compile-time
   environment is the same as the runtime environment, particularly in the
   case where we read a volume created on another machine.

   Also, it's desirable for scripts that pipe the output of this routine to
   cut -c not to depend on where lsattr etc. were compiled. */

#include <stdio.h>

#include "e2p.h"

#if 0  /* Original.  This code can be removed. */
static const unsigned long flags_array[] = {
	EXT2_SECRM_FL,
	EXT2_UNRM_FL,
	EXT2_COMPR_FL,
	EXT2_SYNC_FL,
#ifdef	EXT2_IMMUTABLE_FL
	EXT2_IMMUTABLE_FL,
#endif
#ifdef	EXT2_APPEND_FL
	EXT2_APPEND_FL,
#endif
#ifdef	EXT2_NODUMP_FL
	EXT2_NODUMP_FL,
#endif
#ifdef	EXT2_NOATIME_FL
	EXT2_NOATIME_FL,
#endif
	0};

static const char * short_flags[] = {
	"s",
	"u",
	"c",
	"S",
#ifdef	EXT2_IMMUTABLE_FL
	"i",
#endif
#ifdef	EXT2_APPEND_FL
	"a",
#endif
#ifdef	EXT2_NODUMP_FL
	"d",
#endif
#ifdef	EXT2_NOATIME_FL
	"A",
#endif
	NULL};

static const char * long_flags[] = {
	"Secure_Deletion",
	"Undelete",
	"Compressed_File",
	"Synchronous_Updates",
#ifdef	EXT2_IMMUTABLE_FL
	"Immutable",
#endif
#ifdef	EXT2_APPEND_FL
	"Append_Only",
#endif
#ifdef	EXT2_NODUMP_FL
	"No_Dump",
#endif
#ifdef	EXT2_NOATIME_FL
	"No_Atime, ",
#endif
	NULL};

void print_flags (FILE * f, unsigned long flags, int long_format)
{
	int i;
	const char ** flags_names;

	if (long_format)
		flags_names = long_flags;
	else
		flags_names = short_flags;

	for (i = 0; flags_array[i] != 0; i++)
	{
		if (flags & flags_array[i])
			fprintf (f, flags_names[i]);
		else
			putc ('-', f);
		if (long_format)
			fputs (", ", f);
	}
}
#else
static void print_flag (FILE *f, unsigned long flag_p, int long_format, const char *str, char ch)
{
	if (flag_p)
		if (long_format)
			fputs (str, f);
		else
			putc (ch, f);
	else
		putc ('-', f);
}

void print_flags (FILE * f, unsigned long flags, int long_format)
{
	print_flag (f, flags & EXT2_SECRM_FL, long_format, "Secure_Deletion", 's');

	if (long_format)
		fputs (", ", f);
	print_flag (f, flags & EXT2_UNRM_FL, long_format, "Undelete", 'u');

	if (long_format)
		fputs (", ", f);
#ifdef EXT2_ECOMPR_FL
# ifndef TRUE
#  define TRUE 1
# endif
	if (flags & EXT2_NOCOMPR_FL)
		print_flag (f, TRUE, long_format, "Compression_Disabled", '*');
	else if (flags & EXT2_ECOMPR_FL)
		print_flag (f, TRUE, long_format, "Compression_Error", 'E');
	else 
		print_flag (f, flags & EXT2_COMPR_FL, long_format, "Compressed_File", 'c');
#else
	print_flag (f, flags & EXT2_COMPR_FL, long_format, "Compressed_File", 'c');
#endif

	if (long_format)
		fputs (", ", f);
	print_flag (f, flags & EXT2_SYNC_FL, long_format, "Synchronous_Updates", 'S');

#ifdef EXT2_IMMUTABLE_FL
	if (long_format)
		fputs (", ", f);
	print_flag (f, flags & EXT2_IMMUTABLE_FL, long_format, "Immutable", 'i');
#endif

#ifdef	EXT2_APPEND_FL
	if (long_format)
		fputs (", ", f);
	print_flag (f, flags & EXT2_APPEND_FL, long_format, "Append_Only", 'i');
#endif

#ifdef	EXT2_NODUMP_FL
	if (long_format)
		fputs (", ", f);
	print_flag (f, flags & EXT2_NODUMP_FL, long_format, "No_Dump", 'i');
#endif
}
#endif
