'\"
'\" Copyright (c) 1995 Marco Beijersbergen (beijersb@rulhm1.leidenuniv.nl)
'\" See the file "license.terms" for information on usage and
'\" redistribution of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" Based upon scale.n of the tk4.0b3 package:
'\"   Copyright (c) 1990-1994 The Regents of the University of California.
'\"   Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\" See the file "license.terms.tk" for information on usage and
'\" redistribution of that file, and for a DISCLAIMER OF ALL WARRANTIES
'\" on their behalf.
'\" 
'\" @(#) turndial.n 1.06 95/06/22 15:55:21
'/" 
.so man.macros
.HS turndial tk 4.0
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
turndial \- Create and manipulate turndial widgets
.SH SYNOPSIS
\fBturndial\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.VS
\fBactiveBackground\fR	\fBfont\fR
\fBhighlightThickness\fR	\fBrepeatInterval\fR
\fBbackground\fR	\fBforeground\fR	\fBtakeFocus\fR
\fBborderWidth\fR	\fBhighlightBackground\fR
\fBrelief\fR	\fBknobColor\fR	\fBmarkColor\fR
\fBfont\fR	\fBcursor\fR	\fBhighlightColor\fR
\fBrepeatDelay\fR	\fBrepeatInterval\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:	\fBbeginAngle\fR
.VS
Class:	\fBBeginAngle\fR
Command-Line Switch:	\fB\-beginangle\fR
.fi
.IP
The angle at which the scale of the turndial will start. The
value is in degrees. Zero is at the top and the angle increases
clockwise, just like a compass. If you want the scale to start
at the left, use a negative value, not the value above
180 degrees.
.VE
.LP
.nf
Name:	\fBbigIncrement\fR
.VS
Class:	\fBBigIncrement\fR
Command-Line Switch:	\fB\-bigincrement\fR
.fi
.IP
Some interactions with the turndial cause its value to change by
``large'' increments;  this option specifies the size of the
large increments.  If specified as 0, the large increments default
to 1/10 the range of the turndial.
.VE
.LP
.nf
Name:	\fBcommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB\-command\fR
.fi
.IP
Specifies the prefix of a Tcl command to invoke whenever the turndial's
.VS
value is changed via a widget command.
.VE
The actual command consists
of this option followed by a space and a real number indicating the
new value of the turndial.
.LP
.nf
.VS
Name:	\fBdigits\fR
Class:	\fBDigits\fR
Command-Line Switch:	\fB\-digits\fR
.fi
.IP
An integer specifying how many significant digits should be retained
when converting the value of the turndial to a string.
If the number is less than or equal to zero, then the turndial picks
the smallest value that guarantees that every possible knob
position prints as a different string.
.VE
.LP
.nf
Name:	\fBendAngle\fR
.VS
Class:	\fBEndAngle\fR
Command-Line Switch:	\fB\-endangle\fR
.fi
.IP
The angle at which the scale of the turndial will end. The
value is in degrees. Zero is at the top and the angle increases
clockwise, just like a compass.
.VE
.LP
.nf
Name:	\fBfrom\fR
Class:	\fBFrom\fR
Command-Line Switch:	\fB\-from\fR
.fi
.IP
A real value corresponding to the counterclockwise-most end of the turndial.
.LP
.nf
Name:	\fBlabel\fR
Class:	\fBLabel\fR
Command-Line Switch:	\fB\-label\fR
.fi
.IP
A string to display as a label for the turndial.
The label is displayed above the turndial.  If the option is specified
as an empty string, no label is displayed.
.LP
.nf
Name:	\fBradius\fR
Class:	\fBRadius\fR
Command-Line Switch:	\fB\-radius\fR
.fi
.IP
Specifies the desired radius of the central knob of the turndial in
screen units (i.e. any form acceptable to Tk_GetPixels).
.LP
.nf
.VS
Name:	\fBresolution\fR
Class:	\fBResolution\fR
Command-Line Switch:	\fB\-resolution\fR
.fi
.IP
A real value specifying the resolution for the turndial.
If this value is greater than zero then the turndial's value will always be
rounded to an even multiple of this value, as will tick marks and
the endpoints of the turndial.  If the value is less than zero then no
rounding occurs.  Defaults to 1 (i.e., the value will be integral).
.VE
.LP
.nf
Name:	\fBshowValue\fR
Class:	\fBShowValue\fR
Command-Line Switch:	\fB\-showvalue\fR
.fi
.IP
Specifies a boolean value indicating whether or not the current
value of the turndial is to be displayed.
.LP
.nf
Name:	\fBshowTags\fR
Class:	\fBShowTags\fR
Command-Line Switch:	\fB\-showtags\fR
.fi
.IP
Specifies a boolean value which indicates whether or not
numerical values have to be displayed next to the ticks.
.LP
.nf
Name:	\fBstate\fR
Class:	\fBState\fR
Command-Line Switch:	\fB\-state\fR
.fi
.IP
Specifies one of three states for the turndial:  \fBnormal\fR,
.VS
\fBactive\fR, or \fBdisabled\fR.
If the turndial is disabled then the value may not be changed and the
turndial won't activate.
If the turndial is active, the knob is displayed using the color
specified by the \fBactiveBackground\fR option.
.VE
.LP
.nf
Name:	\fBtickInterval\fR
Class:	\fBTickInterval\fR
Command-Line Switch:	\fB\-tickinterval\fR
.fi
.IP
Must be a real value.
Determines the spacing between numerical
tick marks around the knob.
If 0, no tick marks will be displayed.
.LP
.nf
Name:	\fBminorTickInterval\fR
Class:	\fBMinorTickInterval\fR
Command-Line Switch:	\fB\-minortickinterval\fR
.fi
.IP
Must be a real value.
Determines the spacing between tick marks
without a numerical value. These ticks are also
slightly smaller. If 0, no tick marks will be displayed.
.LP
.nf
Name:	\fBto\fR
Class:	\fBTo\fR
Command-Line Switch:	\fB\-to\fR
.fi
.IP
Specifies a real value corresponding
to the clockwise-most end of the turndial.
This value may be either less than or greater than the \fBfrom\fR option.
.LP
.nf
Name:	\fBvariable\fR
Class:	\fBVariable\fR
Command-Line Switch:	\fB\-variable\fR
.fi
.IP
Specifies the name of a global variable to link to the turndial.  Whenever the
value of the variable changes, the turndial will update to reflect this
value.
Whenever the turndial is manipulated interactively, the variable
will be modified to reflect the turndial's new value.
.BE

.SH DESCRIPTION
.PP
The \fBturndial\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a turndial widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the turndial such as its colors and relief.
The \fBturndial\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A turndial is a widget that displays a circular \fIknob\fR with a small
\fImark\fR. The position of the knob selects a particular real value
of the scale which is determined by the \fBfrom\fR, \fBto\fR, and
\fBresolution\fR options.
The knob may be turned (and hence the turndial's value changed)
.VS
with the mouse or keyboard as described in the BINDINGS
.VE
section below.  Whenever the turndial's value is changed, a Tcl
command is invoked (using the \fBcommand\fR option) to notify
other interested widgets of the change.
In addition, the value
of the turndial can be linked to a Tcl variable (using the \fBvariable\fR
option), so that changes in either are reflected in the other.
.PP
Five annotations may be displayed in a turndial widget:  a label
appearing at the top left of the widget, a number displaying the
current value just below the knob, a collection
of major tick marks, numerical labels next to the major tick marks and
a collection of minor tick marks. Each of these five annotations may be
enabled or disabled using the configuration options.

.SH "WIDGET COMMAND"
.PP
The \fBturndial\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for turndial widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
.VS
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBturndial\fR
command.
.VE
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBturndial\fR
command.
.TP
\fIpathName \fBcoords\fR \fR?\fIvalue\fR?
.VS
Returns a list whose elements are the x and y coordinates of
the point along the radius of the knob  that corresponds
to \fIvalue\fR.
If \fIvalue\fR is omitted then the turndial's current value is used.
.TP
\fIpathName \fBget\fR ?\fIx y\fR?
If \fIx\fR and \fIy\fR are omitted, returns the current value
of the turndial.  If \fIx\fR and \fIy\fR are specified, they give
pixel coordinates within the widget;  the command returns
the turndial value corresponding to the given pixel.
.TP
\fIpathName \fBidentify\fR \fIx y\fR
Returns a string indicating what part of the turndial lies under
the coordinates given by \fIx\fR and \fIy\fR.
A return value of \fBknob\fR means that the point is over
the knob;  \fBleft\fR means that the point is to the left of the
knob,
and \fBright\fR means that the point is to the right of the
knob.
.VE
.TP
\fIpathName \fBset\fR \fIvalue\fR
This command is invoked to change the current value of the turndial,
and hence the orientation of the knob.  \fIValue\fR
gives the new value for the turndial.
The command has no effect if the turndial is disabled.

.SH BINDINGS
.PP
Tk automatically creates class bindings for turndials that give them
the following default behavior.
.IP [1]
If button 1 is pressed at the area around the knob,
the turndial's value will be incremented or decremented by
the value of the \fBresolution\fR
option. If you press left of the knob, the knob will turn counterclockwise; 
if you press at the right it turns clockwise.
If the button is held down, the action auto-repeats.
.IP [2]
If button 1 is pressed over the knob, the knob is turned towards the
mouse cursor. If the button is held down, the knob orientation can be
dragged with the mouse.
.IP [3]
If button 1 is pressed at the surrounding with the Control key down,
the knob turns all the way to the end of its range. If the cursor was at
the left, it goes to the lower limit; if it was at the right, it goes to the
upper limit.
.IP [4]
The Down and Left keys turn the knob counterclockwise by the value
of the \fBresolution\fR option.
.IP [5]
The Up and Right keys turn the knob clockwise by the value
of the \fBresolution\fR option.
.IP [6]
Control-Down and Control-Left turn the knob counterclockwise by the
value of the \fBbigIncrement\fR option.
.IP [7]
Control-Up and Control-Right turn the knob clockwise by the
value of the \fBbigIncrement\fR option.
.IP [8]
Home turns the knob to the lower end of its range.
.IP [9]
End moves the knob to the higher end of its range.
.PP
If the turndial is disabled using the \fBstate\fR option then
none of the above bindings have any effect.
.PP
The behavior of turndials can be changed by defining new bindings for
individual widgets or by redefining the class bindings.
.VE

.SH KEYWORDS
turndial, knob, widget
