'\"
'\" This man page was derived from the tk_stripchart.3 man page.
'\" by Francis Gardner.
'\"
'\" 13/10/92 (or 10/13/92 if you are American)
'\"
'\" Copyright 1990 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\"
'/"
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"     Replacement for .TH in other man pages.  See below for valid
.\"     section names.
.\"
.\" .AP type name in/out [indent]
.\"     Start paragraph describing an argument to a library procedure.
.\"     type is type of argument (int, etc.), in/out is either "in", "out",
.\"     or "in/out" to describe whether procedure reads or modifies arg,
.\"     and indent is equivalent to second arg of .IP (shouldn't ever be
.\"     needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"     Give maximum sizes of arguments for setting tab stops.  Type and
.\"     name are examples of largest possible arguments that will be passed
.\"     to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"     Start box enclosure.  From here until next .BE, everything will be
.\"     enclosed in one large box.
.\"
.\" .BE
.\"     End of box enclosure.
.\"
.\" .VS
.\"     Begin vertical sidebar, for use in marking newly-changed parts
.\"     of man pages.
.\"
.\" .VE
.\"     End of vertical sidebar.
.\"
.\" .DS
.\"     Begin an indented unfilled display.
.\"
.\" .DE
.\"     End of indented unfilled display.
.\"
'       # Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'       # Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1  \\fI\\$2\\fP    (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1  \\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'       # define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'       # BS - start boxed text
'       # ^y = starting y location
'       # ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'       # BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"     Draw four-sided box normally, but don't draw top of
.\"     box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'       # VS - start vertical sidebar
'       # ^Y = starting y location
'       # ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'       # VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'       # Special macro to handle page bottom:  finish off current
'       # box/sidebar if in box/sidebar mode, then invoked standard
'       # page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"     Draw three-sided box if this is the box's first page,
.\"     draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'       # DS - begin display
.de DS
.RS
.nf
.sp
..
'       # DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS dial cmds
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
dial \- Create and manipulate dial widgets
.SH SYNOPSIS
\fBdial\fI \fIpathName \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBborderWidth\fR	\fBfont\fR	\fBrelief\fR	\fBcursor\fR
\fBbackground\fR
.fi
.LP
See the ``options'' manual entry for details on the standard options.
.SH "WIDGET-SPECIFIC OPTIONS"
.ta 4c
.LP
.nf
Name:   \fBneedlecolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-needlecolor\fR
.fi
.IP
Specifies the colour that the dial needle should be rendered.  On a
colour display this defaults to red and on a monochrome display the
default is black.
.LP
.nf
Name:   \fBtextcolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-textcolor\fR
.fi
.IP
Specifies the colour that dial text should be rendered.  On both
colour and monochrome displays this defaults to black.
.LP
.nf
Name:   \fBtickcolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-tickcolor\fR
.fi
.IP
Specifies the colour that dial ticks should be rendered.  On a
colour display this defaults to blue2 and on a monochrome display the
default is black.
.LP
.nf
Name:   \fBmajortickcolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-majortickcolor\fR
.fi
.IP
Specifies the colour that dial major ticks should be rendered.  On a
colour display this defaults to blue4 and on a monochrome display the
default is black.
.LP
.nf
Name:   \fBcommand\fR
Class:  \fBCommand\fR
Command-Line Switch:    \fB\-command\fR
.fi
.IP
This is a Tcl command to be executed periodically when callback is started.
.LP
.nf
Name:   \fBinterval\fR
Class:  \fBInterval\fR
Command-Line Switch:    \fB\-interval\fR
.fi
.IP
This specifies the time between sucessive callbacks, in milliseconds.
.LP
.nf
Name:   \fBaltbackground\fR
Class:  \fBBackground\fR
Command-Line Switch:    \fB\-altbackground\fR
.fi
.IP
Specifies the alternative background colour.  The default colour on a colour
display is red2 and black on a monoshrome display.
.LP
.nf
Name:   \fBaltneedlecolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-altneedlecolor\fR
.fi
.IP
Specifies the alternative needle colour.  The default colour on a colour
display is green and white on a monoshrome display. 
.LP
.nf
Name:   \fBalttextcolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-alttextcolor\fR
.fi
.IP
Specifies the alternative text colour.  The default colour on both a colour
and monochrome display is white.
.LP
.nf
Name:   \fBalttickcolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-alttickcolor\fR
.fi
.IP
Specifies the alternative tick colour.  The default colour on a colour
display is gray70 and white on a monoshrome display.
.LP
.nf
Name:   \fBaltmajortickcolor\fR
Class:  \fBForeground\fR
Command-Line Switch:    \fB\-altmajortickcolor\fR
.fi
.IP
Specifies the alternative major tick colour.  The default colour is gray70
on a colour display and white on a monochrome display.
.LP
.nf
Name:   \fBshowticks\fR
Class:  \fBShowticks\fR
Command-Line Switch:    \fB\-showticks\fR
.fi
.IP
This boolean flag specifies whether or not ticks should be displayed.
Defaults to true.
.LP
.nf
Name:   \fBshowvalue\fR
Class:  \fBShowvalue\fR
Command-Line Switch:    \fB\-showvalue\fR
.fi
.IP
This boolean flag specifies whether or not text below the needle should be
displayed.  This text is the current value of the dial.  Defaults to true.
.LP
.nf
Name:   \fBminvalue\fR
Class:  \fBMinvalue\fR
Command-Line Switch:    \fB\-minvalue\fR
.fi
.IP
Specifies the minimum value the dial can display.  Defaults to 0.
.LP
.nf
Name:   \fBmaxvalue\fR
Class:  \fBMaxvalue\fR
Command-Line Switch:    \fB\-maxvalue\fR
.fi
.IP
Specifies the maximum value the dial can display.  Defaults to 1000.
.LP
.nf
Name:   \fBbegindegree\fB
Class:  \fBBegindegree\fB
Command-Line Switch:    \fB-begindegree\fB
.fi
.IP
Specifies the angle at which the needle should point when it is displaying
the minvalue.  This should be a value between 0 and 360 (degrees) inclusive.
0 (and 360) are straight up, 180 is straight down and so on.  The default
begin angle is 300 degrees.
.LP
.nf
Name:   \fBenddegree\fB
Class:  \fBEnddegree\fB
Command-Line Switch:    \fB-enddegree\fB
.fi
.IP
Specifies the angle at which the needle should point when it is displaying
the maxvalue.  This should be a value between 0 and 360 (degrees) inclusive.
The default begin angle is 60 degrees.
.LP
.nf
Name:   \fBtitle\fR
Class:  \fBTitle\fR
Command-Line Switch:    \fB\-title\fR
.fi
.IP
This string is placed on the top of the widget as the widgets title.  By
default there is no title.  Specifying a blank title ("") will remove the
title.
.LP
.nf
Name:   \fBradius\fR
Class:  \fBRadius\fR
Command-Line Switch:    \fB\-radius\fR
.fi
.IP
Specifies the radius of the dial needle in pixels.  Defaults to 60 pixels.
.LP
.nf
Name:   \fBnumticks\fR
Class:  \fBNumticks\fR
Command-Line Switch:    \fB\-numticks\fR
.fi
.IP
Specifies the number of ticks that should be displayed if ticks are being
shown.  Default is 30.  This option should really be tickinterval.
.LP
.nf
Name:   \fBmajorticks\fR
Class:  \fBMajorticks\fR
Command-Line Switch:    \fB\-majorticks\fR
.fi
.IP
Specifies the frequency of major ticks.  If the argument is '1' then all
ticks are major ticks.  If the argument is 'x', every x'th tick is a major
tick.
.LP
.nf
Name:   \fBdata\fR
Class:  \fBData\fR
Command-Line Switch:    \fB\-data\fR
.fi
.IP
This is a string that can be associated with each widget.
.LP
.nf
Name:   \fBuserbits\fR
Class:  \fBUserbits\fR
Command-Line Switch:    \fB\-userbits\fR
.fi
.IP
This is an integer that can be associated with each widget.
.BE

.SH DESCRIPTION
.PP
The \fBdial\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a dial widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the dial such as its colors, font,
text, and initial relief.  The \fBdial\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A dial is a widget
for displaying data.  It has the appearance of a UV meter.

.SH "WIDGET COMMAND"
.PP
The \fBdial\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for dial widgets:
.TP
\fIpathName \fBset\fR ?\fIvalue\fR?
Add a new needle with the specified value to the dial.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBdial\fR
command.
.TP
\fIpathName \fBget\fR
Returns the current value of the dial.
.TP
\fIpathName \fBstart\fR
Starts the callback routine.  The Tcl command given in the -command switch
is executed periodically .  The period is given in the -interval switch
(in seconds).
.TP
\fIpathName \fBstop\fR
Stops the callback routine.
.TP
\fIpathName \fBswap\fR
Swaps the current colour scheme with the alternative colour scheme and
redisplays the widget with this new colour scheme.
.TP
\fIpathName \fBreplace\fP ?\fIoption\fR? ?\fIvalue option value ...\fR?
Saves the current colour scheme (in the alternative colour scheme) and
reconfigures the widget with the specified options.
.TP

.SH KEYWORDS
dial, widget
