/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.LayoutManager;
import netscape.application.Size;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class GridLayout
implements LayoutManager,
Codable {
    int rowCount;
    int columnCount;
    int horizGap;
    int vertGap;
    int flowDirection;
    public static final int FLOW_ACROSS = 0;
    public static final int FLOW_DOWN = 1;
    static final String ROWCOUNT_KEY = "rowCount";
    static final String COLUMNCOUNT_KEY = "columnCount";
    static final String HORIZGAP_KEY = "horizGap";
    static final String VERTGAP_KEY = "vertGap";
    static final String FLOWDIRECTION_KEY = "flowDirection";

    public GridLayout() {
        this(0, 0, 0, 0, 0);
    }

    public GridLayout(int n, int n2) {
        this(n, n2, 0, 0, 0);
    }

    public GridLayout(int n, int n2, int n3, int n4, int n5) {
        this.setRowCount(n);
        this.setColumnCount(n2);
        this.horizGap = n3;
        this.vertGap = n4;
        this.setFlowDirection(n5);
    }

    public void setRowCount(int n) {
        this.rowCount = n >= 0 ? n : 0;
    }

    public int rowCount() {
        return this.rowCount;
    }

    public void setColumnCount(int n) {
        this.columnCount = n >= 0 ? n : 0;
    }

    public int columnCount() {
        return this.columnCount;
    }

    public void setHorizGap(int n) {
        this.horizGap = n;
    }

    public int horizGap() {
        return this.horizGap;
    }

    public void setVertGap(int n) {
        this.vertGap = n;
    }

    public int vertGap() {
        return this.vertGap;
    }

    public void setFlowDirection(int n) {
        if (n == 0 || n == 1) {
            this.flowDirection = n;
            return;
        }
        throw new InconsistencyException(String.valueOf(this) + "Invalid Flow direction specified: " + n);
    }

    public int flowDirection() {
        return this.flowDirection;
    }

    public void addSubview(View view) {
    }

    public void removeSubview(View view) {
    }

    public void layoutView(View view, int n, int n2) {
        Vector vector = view.subviews();
        int n3 = vector.count();
        if (n3 < 1) {
            return;
        }
        Size size = this.gridSize(view);
        int n4 = size.width;
        int n5 = size.height;
        int n6 = (view.bounds.width - this.horizGap * n4 - this.horizGap) / n4;
        int n7 = (view.bounds.height - this.vertGap * n5 - this.vertGap) / n5;
        int n8 = 0;
        int n9 = 0;
        if (this.flowDirection == 1) {
            int n10 = 0;
            while (n10 < n3) {
                int n11 = n6 * n9 + this.horizGap * (n9 + 1);
                int n12 = n7 * n8 + this.vertGap * (n8 + 1);
                View view2 = (View)vector.elementAt(n10);
                view2.setBounds(n11, n12, n6, n7);
                if (n5 > 0 && ++n8 >= n5) {
                    ++n9;
                    n8 = 0;
                }
                ++n10;
            }
            return;
        }
        int n13 = 0;
        while (n13 < n3) {
            int n14 = n6 * n9 + this.horizGap * (n9 + 1);
            int n15 = n7 * n8 + this.vertGap * (n8 + 1);
            View view3 = (View)vector.elementAt(n13);
            view3.setBounds(n14, n15, n6, n7);
            if (n4 > 0 && ++n9 >= n4) {
                ++n8;
                n9 = 0;
            }
            ++n13;
        }
    }

    public Size gridSize(View view) {
        int n;
        int n2;
        int n3 = view.subviews().count();
        if (n3 < 1) {
            return new Size();
        }
        if (this.rowCount == 0) {
            if (this.columnCount == 0) {
                n = n2 = (int)Math.ceil(Math.sqrt(n3));
            } else {
                n2 = this.columnCount;
                n = (int)Math.ceil((float)n3 / (float)n2);
            }
        } else if (this.columnCount == 0) {
            if (this.rowCount == 0) {
                n = n2 = (int)Math.ceil(Math.sqrt(n3));
            } else {
                n = this.rowCount;
                n2 = (int)Math.ceil((float)n3 / (float)n);
            }
        } else {
            n = this.rowCount;
            n2 = this.columnCount;
        }
        return new Size(n2, n);
    }

    public void describeClassInfo(ClassInfo classInfo) {
        classInfo.addClass("netscape.application.GridLayout", 1);
        classInfo.addField(ROWCOUNT_KEY, (byte)8);
        classInfo.addField(COLUMNCOUNT_KEY, (byte)8);
        classInfo.addField(HORIZGAP_KEY, (byte)8);
        classInfo.addField(VERTGAP_KEY, (byte)8);
        classInfo.addField(FLOWDIRECTION_KEY, (byte)8);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.rowCount = decoder.decodeInt(ROWCOUNT_KEY);
        this.columnCount = decoder.decodeInt(COLUMNCOUNT_KEY);
        this.horizGap = decoder.decodeInt(HORIZGAP_KEY);
        this.vertGap = decoder.decodeInt(VERTGAP_KEY);
        this.flowDirection = decoder.decodeInt(FLOWDIRECTION_KEY);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(ROWCOUNT_KEY, this.rowCount);
        encoder.encodeInt(COLUMNCOUNT_KEY, this.columnCount);
        encoder.encodeInt(HORIZGAP_KEY, this.horizGap);
        encoder.encodeInt(VERTGAP_KEY, this.vertGap);
        encoder.encodeInt(FLOWDIRECTION_KEY, this.flowDirection);
    }

    public void finishDecoding() throws CodingException {
    }
}

